/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.table.internal;

import java.util.Comparator;

public class AlphanumericComparator
implements Comparator<String> {
    private final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private final String getChunk(String s, int slength, int marker) {
        StringBuilder chunk = new StringBuilder();
        char c = s.charAt(marker);
        chunk.append(c);
        ++marker;
        if (this.isDigit(c)) {
            while (marker < slength && this.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        } else {
            while (marker < slength && !this.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        }
        return chunk.toString();
    }

    @Override
    public int compare(String left, String right) {
        int leftMarker = 0;
        int rightMarker = 0;
        int leftLength = left.length();
        int rightLength = right.length();
        while (leftMarker < leftLength && rightMarker < rightLength) {
            String leftChunk = this.getChunk(left, leftLength, leftMarker);
            leftMarker += leftChunk.length();
            String rightChunk = this.getChunk(right, rightLength, rightMarker);
            rightMarker += rightChunk.length();
            int result = 0;
            if (this.isDigit(leftChunk.charAt(0)) && this.isDigit(rightChunk.charAt(0))) {
                int leftChunkLength = leftChunk.length();
                result = leftChunkLength - rightChunk.length();
                if (result == 0) {
                    for (int i = 0; i < leftChunkLength; ++i) {
                        result = leftChunk.charAt(i) - rightChunk.charAt(i);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                result = leftChunk.compareTo(rightChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return leftLength - rightLength;
    }
}

