/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.digitalocean.domain.Droplet;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;

@Singleton
public class DropletToNodeMetadata
implements Function<Droplet, NodeMetadata> {
    private final Supplier<Map<String, ? extends Image>> images;
    private final Supplier<Map<String, ? extends Hardware>> hardwares;
    private final Supplier<Set<? extends Location>> locations;
    private final Function<Droplet.Status, NodeMetadata.Status> toPortableStatus;
    private final GroupNamingConvention groupNamingConvention;
    private final Map<String, Credentials> credentialStore;

    @Inject
    DropletToNodeMetadata(Supplier<Map<String, ? extends Image>> images, Supplier<Map<String, ? extends Hardware>> hardwares, @Memoized Supplier<Set<? extends Location>> locations, Function<Droplet.Status, NodeMetadata.Status> toPortableStatus, GroupNamingConvention.Factory groupNamingConvention, Map<String, Credentials> credentialStore) {
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images cannot be null");
        this.hardwares = (Supplier)Preconditions.checkNotNull(hardwares, (Object)"hardwares cannot be null");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations cannot be null");
        this.toPortableStatus = (Function)Preconditions.checkNotNull(toPortableStatus, (Object)"toPortableStatus cannot be null");
        this.groupNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)groupNamingConvention, (Object)"groupNamingConvention cannot be null")).createWithoutPrefix();
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore cannot be null");
    }

    public NodeMetadata apply(Droplet input) {
        Credentials credentials;
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(String.valueOf(input.getId()));
        builder.name(input.getName());
        builder.hostname(input.getName());
        builder.group(this.groupNamingConvention.extractGroup(input.getName()));
        builder.hardware((Hardware)((Map)this.hardwares.get()).get(String.valueOf(input.getSizeId())));
        final String regionIdPattern = input.getRegionId() + "/";
        builder.location((Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)new Predicate<Location>(){

            public boolean apply(Location location) {
                return location.getDescription().startsWith(regionIdPattern);
            }
        }));
        Image image = (Image)((Map)this.images.get()).get(String.valueOf(input.getImageId()));
        builder.imageId(image.getId());
        builder.operatingSystem(image.getOperatingSystem());
        builder.status((NodeMetadata.Status)this.toPortableStatus.apply((Object)input.getStatus()));
        builder.backendStatus(input.getStatus().name());
        if (input.getIp() != null) {
            builder.publicAddresses((Iterable)ImmutableSet.of((Object)input.getIp()));
        }
        if (input.getPrivateIp() != null) {
            builder.privateAddresses((Iterable)ImmutableSet.of((Object)input.getPrivateIp()));
        }
        if ((credentials = this.credentialStore.get("node#" + input.getId())) instanceof LoginCredentials) {
            builder.credentials((LoginCredentials)LoginCredentials.class.cast(credentials));
        }
        return builder.build();
    }
}

