/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.digitalocean.domain.Region;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.all.JustProvider;

@Singleton
public class RegionToLocation
implements Function<Region, Location> {
    private final JustProvider justProvider;

    @Inject
    RegionToLocation(JustProvider justProvider) {
        this.justProvider = (JustProvider)Preconditions.checkNotNull((Object)justProvider, (Object)"justProvider cannot be null");
    }

    public Location apply(Region input) {
        LocationBuilder builder = new LocationBuilder();
        builder.id(input.getSlug());
        builder.description(input.getId() + "/" + input.getName());
        builder.scope(LocationScope.REGION);
        builder.parent((Location)Iterables.getOnlyElement((Iterable)this.justProvider.get()));
        builder.iso3166Codes((Iterable)ImmutableSet.of());
        return builder.build();
    }
}

