/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.features;

import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.DropletCreation;
import org.jclouds.digitalocean.domain.Event;
import org.jclouds.digitalocean.internal.BaseDigitalOceanLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="EventApiLiveTest")
public class EventApiLiveTest
extends BaseDigitalOceanLiveTest {
    protected void initialize() {
        super.initialize();
        this.initializeImageSizeAndRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetEvent() {
        DropletCreation droplet = null;
        try {
            droplet = ((DigitalOceanApi)this.api).getDropletApi().create("eventtest", this.defaultImage.getId(), this.defaultSize.getId(), this.defaultRegion.getId());
            Event event = ((DigitalOceanApi)this.api).getEventApi().get(droplet.getEventId());
            Assert.assertNotNull((Object)event, (String)"Droplet creation event should not be null");
            Assert.assertTrue((event.getId() > 0 ? 1 : 0) != 0, (String)"Event id should be > 0");
        }
        finally {
            if (droplet != null) {
                this.waitForEvent(droplet.getEventId());
                ((DigitalOceanApi)this.api).getDropletApi().destroy(droplet.getId(), true);
            }
        }
    }
}

