/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.io.InputStream;
import java.util.List;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.SshKey;
import org.jclouds.digitalocean.features.KeyPairApi;
import org.jclouds.digitalocean.internal.BaseDigitalOceanMockTest;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="KeyPairApiMockTest")
public class KeyPairApiMockTest
extends BaseDigitalOceanMockTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListKeys() throws Exception {
        MockWebServer server = KeyPairApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/keys.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        KeyPairApi keyPairApi = api.getKeyPairApi();
        try {
            List keys = keyPairApi.list();
            KeyPairApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/ssh_keys");
            Assert.assertEquals((int)keys.size(), (int)1);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetKey() throws Exception {
        MockWebServer server = KeyPairApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/key.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        KeyPairApi keyPairApi = api.getKeyPairApi();
        try {
            SshKey key = keyPairApi.get(47);
            KeyPairApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/ssh_keys/47");
            Assert.assertEquals((int)key.getId(), (int)47);
            Assert.assertEquals((String)key.getName(), (String)"my_key");
            Assert.assertNotNull((Object)key.getPublicKey());
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetUnexistingKey() throws Exception {
        MockWebServer server = KeyPairApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        KeyPairApi keyPairApi = api.getKeyPairApi();
        try {
            SshKey key = keyPairApi.get(47);
            KeyPairApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/ssh_keys/47");
            Assert.assertNull((Object)key);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateKey() throws Exception {
        MockWebServer server = KeyPairApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/key.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        KeyPairApi keyPairApi = api.getKeyPairApi();
        try {
            String publicKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/ssh-rsa.txt"));
            SshKey key = keyPairApi.create("my_key", publicKey);
            KeyPairApiMockTest.assertRequestHasParameters(server.takeRequest(), "/ssh_keys/new", (Multimap<String, String>)ImmutableMultimap.of((Object)"name", (Object)"my_key", (Object)"ssh_pub_key", (Object)publicKey));
            Assert.assertEquals((int)key.getId(), (int)47);
            Assert.assertEquals((String)key.getName(), (String)"my_key");
            Assert.assertNotNull((Object)key.getPublicKey());
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditKey() throws Exception {
        MockWebServer server = KeyPairApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/key.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        KeyPairApi keyPairApi = api.getKeyPairApi();
        try {
            String publicKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/ssh-rsa.txt"));
            SshKey key = keyPairApi.edit(47, publicKey);
            KeyPairApiMockTest.assertRequestHasParameters(server.takeRequest(), "/ssh_keys/47/edit", (Multimap<String, String>)ImmutableMultimap.of((Object)"ssh_pub_key", (Object)publicKey));
            Assert.assertEquals((int)key.getId(), (int)47);
            Assert.assertEquals((String)key.getName(), (String)"my_key");
            Assert.assertNotNull((Object)key.getPublicKey());
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditUnexistingKey() throws Exception {
        MockWebServer server = KeyPairApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        KeyPairApi keyPairApi = api.getKeyPairApi();
        try {
            String publicKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/ssh-rsa.txt"));
            try {
                keyPairApi.edit(47, publicKey);
                Assert.fail((String)"Edit key should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            KeyPairApiMockTest.assertRequestHasParameters(server.takeRequest(), "/ssh_keys/47/edit", (Multimap<String, String>)ImmutableMultimap.of((Object)"ssh_pub_key", (Object)publicKey));
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteKey() throws Exception {
        MockWebServer server = KeyPairApiMockTest.mockWebServer();
        server.enqueue(new MockResponse());
        DigitalOceanApi api = this.api(server.getUrl("/"));
        KeyPairApi keyPairApi = api.getKeyPairApi();
        try {
            keyPairApi.delete(47);
            KeyPairApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/ssh_keys/47/destroy");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteUnexistingKey() throws Exception {
        MockWebServer server = KeyPairApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        KeyPairApi keyPairApi = api.getKeyPairApi();
        try {
            try {
                keyPairApi.delete(47);
                Assert.fail((String)"Delete key should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            KeyPairApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/ssh_keys/47/destroy");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }
}

