/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jclouds.apis.BaseApiLiveTest;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.Event;
import org.jclouds.digitalocean.domain.Image;
import org.jclouds.digitalocean.domain.Region;
import org.jclouds.digitalocean.domain.Size;
import org.jclouds.util.Predicates2;
import org.testng.Assert;

public class BaseDigitalOceanLiveTest
extends BaseApiLiveTest<DigitalOceanApi> {
    protected static final int DEFAULT_TIMEOUT_SECONDS = 600;
    protected static final int DEFAULT_POLL_SECONDS = 1;
    protected List<Size> sizes;
    protected List<Image> images;
    protected List<Region> regions;
    protected Size defaultSize;
    protected Image defaultImage;
    protected Region defaultRegion;

    public BaseDigitalOceanLiveTest() {
        this.provider = "digitalocean";
    }

    protected void initializeImageSizeAndRegion() {
        this.sizes = BaseDigitalOceanLiveTest.sortedSizes().sortedCopy((Iterable)((DigitalOceanApi)this.api).getSizesApi().list());
        this.regions = ((DigitalOceanApi)this.api).getRegionApi().list();
        this.images = Lists.newArrayList((Iterable)Iterables.filter((Iterable)((DigitalOceanApi)this.api).getImageApi().list(), (Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                return input.isPublicImage();
            }
        }));
        Assert.assertTrue((this.sizes.size() > 1 ? 1 : 0) != 0, (String)"There must be at least two sizes");
        Assert.assertTrue((this.regions.size() > 1 ? 1 : 0) != 0, (String)"There must be at least two regions");
        Assert.assertFalse((boolean)this.images.isEmpty(), (String)"Image list should not be empty");
        this.defaultSize = this.sizes.get(0);
        this.defaultRegion = this.regions.get(0);
        this.defaultImage = this.images.get(0);
    }

    protected void waitForEvent(Integer eventId) {
        Predicates2.retry((Predicate)new Predicate<Integer>(){

            public boolean apply(Integer input) {
                Event event = ((DigitalOceanApi)BaseDigitalOceanLiveTest.this.api).getEventApi().get(input.intValue());
                return Event.Status.DONE == event.getStatus();
            }
        }, (long)600L, (long)1L, (TimeUnit)TimeUnit.SECONDS).apply((Object)eventId);
    }

    protected static Ordering<Size> sortedSizes() {
        return new Ordering<Size>(){

            public int compare(Size left, Size right) {
                return ComparisonChain.start().compare(left.getCpu(), right.getCpu()).compare(left.getMemory(), right.getMemory()).compare(left.getDisk(), right.getDisk()).result();
            }
        };
    }
}

