/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.digitalocean.domain.OperatingSystem;

@Singleton
public class ImageToImage
implements Function<org.jclouds.digitalocean.domain.Image, Image> {
    public Image apply(org.jclouds.digitalocean.domain.Image input) {
        ImageBuilder builder = new ImageBuilder();
        builder.ids(String.valueOf(input.getId()));
        builder.name(input.getName());
        builder.description(input.getName());
        builder.status(Image.Status.AVAILABLE);
        OperatingSystem os = input.getOs();
        builder.operatingSystem(org.jclouds.compute.domain.OperatingSystem.builder().name(input.getName()).family(os.getDistribution().getOsFamily()).description(input.getName()).arch(os.getArch()).version(os.getVersion()).is64Bit(os.is64bit()).build());
        ImmutableMap.Builder metadata = ImmutableMap.builder();
        metadata.put((Object)"publicImage", (Object)String.valueOf(input.isPublicImage()));
        builder.userMetadata((Map)metadata.build());
        return builder.build();
    }
}

