/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.functions;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Set;
import org.jclouds.digitalocean.DigitalOceanProviderMetadata;
import org.jclouds.digitalocean.compute.functions.RegionToLocation;
import org.jclouds.digitalocean.domain.Region;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.all.JustProvider;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RegionToLocationTest")
public class RegionToLocationTest {
    @Test
    public void testConvertRegion() {
        DigitalOceanProviderMetadata metadata = new DigitalOceanProviderMetadata();
        JustProvider locationsSupplier = new JustProvider(metadata.getId(), Suppliers.ofInstance((Object)URI.create(metadata.getEndpoint())), (Set)ImmutableSet.of());
        Region region = new Region(1, "Region 1", "reg1");
        Location expected = new LocationBuilder().id("reg1").description("1/Region 1").parent((Location)Iterables.getOnlyElement((Iterable)locationsSupplier.get())).scope(LocationScope.REGION).build();
        RegionToLocation function = new RegionToLocation(locationsSupplier);
        Assert.assertEquals((Object)function.apply(region), (Object)expected);
    }
}

