/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.domain;

import org.jclouds.digitalocean.domain.Distribution;
import org.jclouds.digitalocean.domain.OperatingSystem;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="OperatingSystemTest")
public class OperatingSystemTest {
    public void testParseStandard64bit() {
        OperatingSystem os = OperatingSystem.builder().from("Ubuntu 12.10 x64", "Ubuntu").build();
        Assert.assertEquals((Object)os.getDistribution(), (Object)Distribution.UBUNTU);
        Assert.assertEquals((String)os.getVersion(), (String)"12.10");
        Assert.assertEquals((String)os.getArch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
    }

    public void testParseStandard() {
        OperatingSystem os = OperatingSystem.builder().from("Ubuntu 12.10 x32", "Ubuntu").build();
        Assert.assertEquals((Object)os.getDistribution(), (Object)Distribution.UBUNTU);
        Assert.assertEquals((String)os.getVersion(), (String)"12.10");
        Assert.assertEquals((String)os.getArch(), (String)"x32");
        Assert.assertFalse((boolean)os.is64bit());
        os = OperatingSystem.builder().from("CentOS 6.5 x64", "CentOS").build();
        Assert.assertEquals((Object)os.getDistribution(), (Object)Distribution.CENTOS);
        Assert.assertEquals((String)os.getVersion(), (String)"6.5");
        Assert.assertEquals((String)os.getArch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
        os = OperatingSystem.builder().from("CentOS 6.5 x64", "Centos").build();
        Assert.assertEquals((Object)os.getDistribution(), (Object)Distribution.CENTOS);
        Assert.assertEquals((String)os.getVersion(), (String)"6.5");
        Assert.assertEquals((String)os.getArch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
    }

    public void testParseNoArch() {
        OperatingSystem os = OperatingSystem.builder().from("Ubuntu 12.10", "Ubuntu").build();
        Assert.assertEquals((Object)os.getDistribution(), (Object)Distribution.UBUNTU);
        Assert.assertEquals((String)os.getVersion(), (String)"12.10");
        Assert.assertEquals((String)os.getArch(), (String)"");
        Assert.assertFalse((boolean)os.is64bit());
    }

    public void testParseNoVersion() {
        OperatingSystem os = OperatingSystem.builder().from("Ubuntu x64", "Ubuntu").build();
        Assert.assertEquals((Object)os.getDistribution(), (Object)Distribution.UBUNTU);
        Assert.assertEquals((String)os.getVersion(), (String)"");
        Assert.assertEquals((String)os.getArch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
    }

    public void testParseUnknownDistribution() {
        OperatingSystem os = OperatingSystem.builder().from("Ubuntu 12.04 x64", "Foo").build();
        Assert.assertEquals((Object)os.getDistribution(), (Object)Distribution.UNRECOGNIZED);
        Assert.assertEquals((String)os.getVersion(), (String)"12.04");
        Assert.assertEquals((String)os.getArch(), (String)"x64");
        Assert.assertTrue((boolean)os.is64bit());
    }
}

