/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.features;

import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.Event;
import org.jclouds.digitalocean.features.EventApi;
import org.jclouds.digitalocean.internal.BaseDigitalOceanMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EventApiMockTest")
public class EventApiMockTest
extends BaseDigitalOceanMockTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetEvent() throws Exception {
        MockWebServer server = EventApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/event.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        EventApi eventApi = api.getEventApi();
        try {
            Event event = eventApi.get(7499);
            EventApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/events/7499");
            Assert.assertNotNull((Object)event);
            Assert.assertEquals((Object)event.getStatus(), (Object)Event.Status.DONE);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPendingEvent() throws Exception {
        MockWebServer server = EventApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/event-pending.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        EventApi eventApi = api.getEventApi();
        try {
            Event event = eventApi.get(7499);
            EventApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/events/7499");
            Assert.assertNotNull((Object)event);
            Assert.assertEquals((Object)event.getStatus(), (Object)Event.Status.PENDING);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetUnexistingEvent() throws Exception {
        MockWebServer server = EventApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        EventApi eventApi = api.getEventApi();
        try {
            Event event = eventApi.get(7499);
            EventApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/events/7499");
            Assert.assertNull((Object)event);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }
}

