/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.util.List;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.Distribution;
import org.jclouds.digitalocean.domain.Image;
import org.jclouds.digitalocean.features.ImageApi;
import org.jclouds.digitalocean.internal.BaseDigitalOceanMockTest;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ImageApiMockTest")
public class ImageApiMockTest
extends BaseDigitalOceanMockTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListImages() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/images.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            List images = imageApi.list();
            ImageApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/images");
            Assert.assertEquals((int)images.size(), (int)3);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetImage() throws Exception {
        String[] imageJsons;
        MockWebServer server = ImageApiMockTest.mockWebServer();
        for (String imageJson : imageJsons = new String[]{"/image1.json", "/image2.json", "/image3.json", "/image2.json"}) {
            server.enqueue(new MockResponse().setBody(this.payloadFromResource(imageJson)));
        }
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            Image image = imageApi.get(1);
            ImageApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/images/1");
            Assert.assertNotNull((Object)image);
            Assert.assertEquals((int)image.getId(), (int)1);
            Assert.assertEquals((Object)image.getOs().getDistribution(), (Object)Distribution.ARCHLINUX);
            Assert.assertEquals((String)image.getOs().getVersion(), (String)"2013.05");
            Assert.assertEquals((String)image.getOs().getArch(), (String)"x32");
            Assert.assertEquals((String)image.getName(), (String)"Arch Linux 2013.05 x32");
            Assert.assertTrue((boolean)image.isPublicImage());
            Assert.assertEquals((String)image.getSlug(), (String)"arch-linux-x32");
            image = imageApi.get(2);
            ImageApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/images/2");
            Assert.assertNotNull((Object)image);
            Assert.assertEquals((int)image.getId(), (int)2);
            Assert.assertEquals((Object)image.getOs().getDistribution(), (Object)Distribution.FEDORA);
            Assert.assertEquals((String)image.getOs().getVersion(), (String)"17");
            Assert.assertEquals((String)image.getOs().getArch(), (String)"x64");
            Assert.assertEquals((String)image.getName(), (String)"Fedora 17 x64 Desktop");
            Assert.assertTrue((boolean)image.isPublicImage());
            Assert.assertEquals((String)image.getSlug(), (String)"fedora-17-x64");
            image = imageApi.get(3);
            ImageApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/images/3");
            Assert.assertNotNull((Object)image);
            Assert.assertNull((Object)image.getSlug());
            Assert.assertEquals((int)image.getId(), (int)3);
            Assert.assertEquals((Object)image.getOs().getDistribution(), (Object)Distribution.UBUNTU);
            Assert.assertEquals((String)image.getOs().getVersion(), (String)"13.04");
            Assert.assertEquals((String)image.getOs().getArch(), (String)"");
            Assert.assertEquals((String)image.getName(), (String)"Dokku on Ubuntu 13.04 0.2.0rc3");
            Assert.assertTrue((boolean)image.isPublicImage());
            Assert.assertNull((Object)image.getSlug());
            image = imageApi.get("fedora-17-x64");
            ImageApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/images/fedora-17-x64");
            Assert.assertNotNull((Object)image);
            Assert.assertEquals((int)image.getId(), (int)2);
            Assert.assertEquals((Object)image.getOs().getDistribution(), (Object)Distribution.FEDORA);
            Assert.assertEquals((String)image.getOs().getVersion(), (String)"17");
            Assert.assertEquals((String)image.getOs().getArch(), (String)"x64");
            Assert.assertEquals((String)image.getName(), (String)"Fedora 17 x64 Desktop");
            Assert.assertTrue((boolean)image.isPublicImage());
            Assert.assertEquals((String)image.getSlug(), (String)"fedora-17-x64");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetUnexistingImage() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            Image image = imageApi.get(15);
            ImageApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/images/15");
            Assert.assertNull((Object)image);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteImage() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer();
        server.enqueue(new MockResponse());
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            imageApi.delete(15);
            ImageApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/images/15/destroy");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteImageUsingSlug() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer();
        server.enqueue(new MockResponse());
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            imageApi.delete("img-15");
            ImageApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/images/img-15/destroy");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteUnexistingImage() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            try {
                imageApi.delete(15);
                Assert.fail((String)"Delete image should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            ImageApiMockTest.assertRequestHasCommonFields(server.takeRequest(), "/images/15/destroy");
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferUnexistingImage() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setResponseCode(404));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            try {
                imageApi.transfer(47, 23);
                Assert.fail((String)"Transfer image should fail on 404");
            }
            catch (ResourceNotFoundException ex) {
                // empty catch block
            }
            ImageApiMockTest.assertRequestHasParameters(server.takeRequest(), "/images/47/transfer", (Multimap<String, String>)ImmutableMultimap.of((Object)"region_id", (Object)"23"));
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferImage() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            int eventId = imageApi.transfer(47, 23);
            ImageApiMockTest.assertRequestHasParameters(server.takeRequest(), "/images/47/transfer", (Multimap<String, String>)ImmutableMultimap.of((Object)"region_id", (Object)"23"));
            Assert.assertEquals((int)eventId, (int)7499);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferImageUsingSlug() throws Exception {
        MockWebServer server = ImageApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.payloadFromResource("/eventid.json")));
        DigitalOceanApi api = this.api(server.getUrl("/"));
        ImageApi imageApi = api.getImageApi();
        try {
            int eventId = imageApi.transfer("img-47", 23);
            ImageApiMockTest.assertRequestHasParameters(server.takeRequest(), "/images/img-47/transfer", (Multimap<String, String>)ImmutableMultimap.of((Object)"region_id", (Object)"23"));
            Assert.assertEquals((int)eventId, (int)7499);
        }
        finally {
            api.close();
            server.shutdown();
        }
    }
}

