/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.http.filters;

import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import org.jclouds.digitalocean.http.filters.AuthenticationFilter;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.Queries;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AuthenticationFilterTest")
public class AuthenticationFilterTest {
    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="credential supplier cannot be null")
    public void testFilterWithoutCredentials() {
        new AuthenticationFilter(null);
    }

    public void testFilterWithCredentials() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost/foo").build();
        LoginCredentials credentials = LoginCredentials.builder().identity("foo").credential("bar").build();
        AuthenticationFilter filter = new AuthenticationFilter(Suppliers.ofInstance((Object)credentials));
        HttpRequest filtered = filter.filter(request);
        String queryLine = filtered.getRequestLine().trim().substring(filtered.getRequestLine().indexOf(63) + 1, filtered.getRequestLine().lastIndexOf(32));
        Multimap params = (Multimap)Queries.queryParser().apply((Object)queryLine);
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)params.get((Object)"client_id"))), (String)"foo");
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)params.get((Object)"api_key"))), (String)"bar");
    }
}

