/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.domain;

import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.name.Named;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class BaseResponse {
    private final Status status;
    @Named(value="error_message")
    private final String message;
    @Named(value="message")
    private final String details;

    @ConstructorProperties(value={"status", "error_message", "message"})
    public BaseResponse(Status status, @Nullable String message, @Nullable String details) {
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status cannot be null"));
        this.message = message;
        this.details = details;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.details;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.details == null ? 0 : this.details.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseResponse other = (BaseResponse)obj;
        if (this.details == null ? other.details != null : !this.details.equals(other.details)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.status == other.status;
    }

    public String toString() {
        return "BaseResponse [status=" + (Object)((Object)this.status) + ", message=" + this.message + ", details=" + this.details + "]";
    }

    public static enum Status {
        OK,
        ERROR;


        public static Status fromValue(String value) {
            Optional status = Enums.getIfPresent(Status.class, (String)value.toUpperCase());
            Preconditions.checkArgument((boolean)status.isPresent(), (String)"Expected one of %s but was %s", (Object[])new Object[]{Joiner.on((char)',').join((Object[])Status.values()), value});
            return (Status)((Object)status.get());
        }
    }
}

