/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.domain;

import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class Droplet {
    private final int id;
    private final String name;
    @Named(value="image_id")
    private final int imageId;
    @Named(value="size_id")
    private final int sizeId;
    @Named(value="region_id")
    private final int regionId;
    @Named(value="backups_active")
    private final boolean backupsActive;
    private final List<Object> backups;
    private final List<Object> snapshots;
    @Named(value="ip_address")
    private final String ip;
    @Named(value="private_ip_address")
    private final String privateIp;
    private final boolean locked;
    private final Status status;
    @Named(value="created_at")
    private final Date creationDate;

    @ConstructorProperties(value={"id", "name", "image_id", "size_id", "region_id", "backups_active", "backups", "snapshots", "ip_address", "private_ip_address", "locked", "status", "created_at"})
    public Droplet(int id, String name, int imageId, int sizeId, int regionId, boolean backupsActive, @Nullable List<Object> backups, @Nullable List<Object> snapshots, String ip, @Nullable String privateIp, boolean locked, Status status, @Nullable Date creationDate) throws ParseException {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.imageId = imageId;
        this.sizeId = sizeId;
        this.regionId = regionId;
        this.backupsActive = backupsActive;
        this.backups = backups != null ? ImmutableList.copyOf(backups) : ImmutableList.of();
        this.snapshots = snapshots != null ? ImmutableList.copyOf(snapshots) : ImmutableList.of();
        this.ip = ip;
        this.privateIp = privateIp;
        this.locked = locked;
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status cannot be null"));
        this.creationDate = creationDate;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getImageId() {
        return this.imageId;
    }

    public int getSizeId() {
        return this.sizeId;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public boolean isBackupsActive() {
        return this.backupsActive;
    }

    public List<Object> getBackups() {
        return this.backups;
    }

    public List<Object> getSnapshots() {
        return this.snapshots;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.backups == null ? 0 : ((Object)this.backups).hashCode());
        result = 31 * result + (this.backupsActive ? 1231 : 1237);
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + this.imageId;
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.locked ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.privateIp == null ? 0 : this.privateIp.hashCode());
        result = 31 * result + this.regionId;
        result = 31 * result + this.sizeId;
        result = 31 * result + (this.snapshots == null ? 0 : ((Object)this.snapshots).hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Droplet other = (Droplet)obj;
        if (this.backups == null ? other.backups != null : !((Object)this.backups).equals(other.backups)) {
            return false;
        }
        if (this.backupsActive != other.backupsActive) {
            return false;
        }
        if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.imageId != other.imageId) {
            return false;
        }
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        if (this.locked != other.locked) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.privateIp == null ? other.privateIp != null : !this.privateIp.equals(other.privateIp)) {
            return false;
        }
        if (this.regionId != other.regionId) {
            return false;
        }
        if (this.sizeId != other.sizeId) {
            return false;
        }
        if (this.snapshots == null ? other.snapshots != null : !((Object)this.snapshots).equals(other.snapshots)) {
            return false;
        }
        return this.status == other.status;
    }

    public String toString() {
        return "Droplet [id=" + this.id + ", name=" + this.name + ", imageId=" + this.imageId + ", sizeId=" + this.sizeId + ", regionId=" + this.regionId + ", backupsActive=" + this.backupsActive + ", backups=" + this.backups + ", snapshots=" + this.snapshots + ", ip=" + this.ip + ", privateIp=" + this.privateIp + ", locked=" + this.locked + ", status=" + (Object)((Object)this.status) + ", creationDate=" + this.creationDate + "]";
    }

    public static enum Status {
        NEW,
        ACTIVE,
        ARCHIVE,
        OFF;


        public static Status fromValue(String value) {
            Optional status = Enums.getIfPresent(Status.class, (String)value.toUpperCase());
            Preconditions.checkArgument((boolean)status.isPresent(), (String)"Expected one of %s but was %s", (Object[])new Object[]{Joiner.on((char)',').join((Object[])Status.values()), value});
            return (Status)((Object)status.get());
        }
    }
}

