/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.features;

import com.google.inject.name.Named;
import java.io.Closeable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.digitalocean.domain.Droplet;
import org.jclouds.digitalocean.domain.DropletCreation;
import org.jclouds.digitalocean.domain.options.CreateDropletOptions;
import org.jclouds.digitalocean.http.filters.AuthenticationFilter;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@Consumes(value={"application/json"})
@Path(value="/droplets")
public interface DropletApi
extends Closeable {
    @Named(value="droplet:list")
    @GET
    @SelectJson(value={"droplets"})
    public List<Droplet> list();

    @Named(value="droplet:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"droplet"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Droplet get(@PathParam(value="id") int var1);

    @Named(value="droplet:create")
    @GET
    @Path(value="/new")
    @SelectJson(value={"droplet"})
    public DropletCreation create(@QueryParam(value="name") String var1, @QueryParam(value="image_id") int var2, @QueryParam(value="size_id") int var3, @QueryParam(value="region_id") int var4);

    @Named(value="droplet:create")
    @GET
    @Path(value="/new")
    @SelectJson(value={"droplet"})
    public DropletCreation create(@QueryParam(value="name") String var1, @QueryParam(value="image_id") int var2, @QueryParam(value="size_id") int var3, @QueryParam(value="region_id") int var4, CreateDropletOptions var5);

    @Named(value="droplet:create")
    @GET
    @Path(value="/new")
    @SelectJson(value={"droplet"})
    public DropletCreation create(@QueryParam(value="name") String var1, @QueryParam(value="image_slug") String var2, @QueryParam(value="size_slug") String var3, @QueryParam(value="region_slug") String var4);

    @Named(value="droplet:create")
    @GET
    @Path(value="/new")
    @SelectJson(value={"droplet"})
    public DropletCreation create(@QueryParam(value="name") String var1, @QueryParam(value="image_slug") String var2, @QueryParam(value="size_slug") String var3, @QueryParam(value="region_slug") String var4, CreateDropletOptions var5);

    @Named(value="droplet:reboot")
    @GET
    @Path(value="/{id}/reboot")
    @SelectJson(value={"event_id"})
    public int reboot(@PathParam(value="id") int var1);

    @Named(value="droplet:powercycle")
    @GET
    @Path(value="/{id}/power_cycle")
    @SelectJson(value={"event_id"})
    public int powerCycle(@PathParam(value="id") int var1);

    @Named(value="droplet:shutdown")
    @GET
    @Path(value="/{id}/shutdown")
    @SelectJson(value={"event_id"})
    public int shutdown(@PathParam(value="id") int var1);

    @Named(value="droplet:poweroff")
    @GET
    @Path(value="/{id}/power_off")
    @SelectJson(value={"event_id"})
    public int powerOff(@PathParam(value="id") int var1);

    @Named(value="droplet:poweron")
    @GET
    @Path(value="/{id}/power_on")
    @SelectJson(value={"event_id"})
    public int powerOn(@PathParam(value="id") int var1);

    @Named(value="droplet:resetpassword")
    @GET
    @Path(value="/{id}/password_reset")
    @SelectJson(value={"event_id"})
    public int resetPassword(@PathParam(value="id") int var1);

    @Named(value="droplet:resize")
    @GET
    @Path(value="/{id}/resize")
    @SelectJson(value={"event_id"})
    public int resize(@PathParam(value="id") int var1, @QueryParam(value="size_id") int var2);

    @Named(value="droplet:snapshot")
    @GET
    @Path(value="/{id}/snapshot")
    @SelectJson(value={"event_id"})
    public int snapshot(@PathParam(value="id") int var1);

    @Named(value="droplet:snapshot")
    @GET
    @Path(value="/{id}/snapshot")
    @SelectJson(value={"event_id"})
    public int snapshot(@PathParam(value="id") int var1, @QueryParam(value="name") String var2);

    @Named(value="droplet:restore")
    @GET
    @Path(value="/{id}/restore")
    @SelectJson(value={"event_id"})
    public int restore(@PathParam(value="id") int var1, @QueryParam(value="image_id") int var2);

    @Named(value="droplet:rebuild")
    @GET
    @Path(value="/{id}/rebuild")
    @SelectJson(value={"event_id"})
    public int rebuild(@PathParam(value="id") int var1, @QueryParam(value="image_id") int var2);

    @Named(value="droplet:rename")
    @GET
    @Path(value="/{id}/rename")
    @SelectJson(value={"event_id"})
    public int rename(@PathParam(value="id") int var1, @QueryParam(value="name") String var2);

    @Named(value="droplet:destroy")
    @GET
    @Path(value="/{id}/destroy")
    @SelectJson(value={"event_id"})
    public int destroy(@PathParam(value="id") int var1);

    @Named(value="droplet:destroy")
    @GET
    @Path(value="/{id}/destroy")
    @SelectJson(value={"event_id"})
    public int destroy(@PathParam(value="id") int var1, @QueryParam(value="scrub_data") boolean var2);
}

