/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.http.filters;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.location.Provider;

@Singleton
public class AuthenticationFilter
implements HttpRequestFilter {
    public static final String IDENTITY_PARAM = "client_id";
    public static final String CREDENTIAL_PARAM = "api_key";
    private final Supplier<Credentials> credentials;

    @Inject
    AuthenticationFilter(@Provider Supplier<Credentials> credentials) {
        this.credentials = (Supplier)Preconditions.checkNotNull(credentials, (Object)"credential supplier cannot be null");
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        Credentials creds = (Credentials)this.credentials.get();
        return request.toBuilder().addQueryParam(IDENTITY_PARAM, new String[]{creds.identity}).addQueryParam(CREDENTIAL_PARAM, new String[]{creds.credential}).build();
    }
}

