/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.functions;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.digitalocean.compute.functions.SizeToHardware;
import org.jclouds.digitalocean.domain.Size;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SizeToHardwareTest")
public class SizeToHardwareTest {
    @Test
    public void testConvertSize() {
        Size size = new Size(1, "Medium", "2gb", 2048, 1, 20, "0.05", "10");
        Hardware expected = new HardwareBuilder().id("2gb").providerId("1").name("Medium").processor(new Processor(1.0, 1.0)).ram(2048).volume(new VolumeBuilder().size(Float.valueOf(20.0f)).type(Volume.Type.LOCAL).build()).userMetadata((Map)ImmutableMap.of((Object)"costPerHour", (Object)"0.05", (Object)"costPerMonth", (Object)"10")).build();
        SizeToHardware function = new SizeToHardware();
        Assert.assertEquals((Object)function.apply(size), (Object)expected);
    }
}

