/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.util;

import org.jclouds.digitalocean.compute.util.LocationNamingUtils;
import org.jclouds.digitalocean.domain.Region;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="LocationNamingUtilsTest")
public class LocationNamingUtilsTest {
    @Test
    public void testExtractRegionId() {
        Assert.assertEquals((int)1, (int)LocationNamingUtils.extractRegionId((Location)LocationNamingUtilsTest.location("1/foo")));
        Assert.assertEquals((int)1, (int)LocationNamingUtils.extractRegionId((Location)LocationNamingUtilsTest.location("1///foo")));
        Assert.assertEquals((int)1, (int)LocationNamingUtils.extractRegionId((Location)LocationNamingUtilsTest.location("1/2/3/foo")));
    }

    @Test
    public void testExtractRegionIdInvalidEncodedForms() {
        LocationNamingUtilsTest.assertInvalidRegionIdFormat("/");
        LocationNamingUtilsTest.assertInvalidRegionIdFormat("/foo");
        LocationNamingUtilsTest.assertInvalidRegionIdFormat("/1/2/foo");
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="location cannot be null")
    public void testExtractRegionIdNullLocation() {
        LocationNamingUtils.extractRegionId(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="location description should be in the form 'regionId/regionName' but was: foobar")
    public void testExtractRegionIdWithoutEncodedForm() {
        LocationNamingUtils.extractRegionId((Location)LocationNamingUtilsTest.location("foobar"));
    }

    @Test
    public void testExtractRegionName() {
        Assert.assertEquals((String)"foo", (String)LocationNamingUtils.extractRegionName((Location)LocationNamingUtilsTest.location("1/foo")));
        Assert.assertEquals((String)"//foo", (String)LocationNamingUtils.extractRegionName((Location)LocationNamingUtilsTest.location("1///foo")));
        Assert.assertEquals((String)"2/3/foo", (String)LocationNamingUtils.extractRegionName((Location)LocationNamingUtilsTest.location("1/2/3/foo")));
    }

    @Test
    public void testExtractRegionNameInvalidEncodedForms() {
        Assert.assertEquals((String)"", (String)LocationNamingUtils.extractRegionName((Location)LocationNamingUtilsTest.location("/")));
        Assert.assertEquals((String)"foo", (String)LocationNamingUtils.extractRegionName((Location)LocationNamingUtilsTest.location("/foo")));
        Assert.assertEquals((String)"1/2/foo", (String)LocationNamingUtils.extractRegionName((Location)LocationNamingUtilsTest.location("/1/2/foo")));
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="location cannot be null")
    public void testExtractRegionNameNullLocation() {
        LocationNamingUtils.extractRegionId(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="location description should be in the form 'regionId/regionName' but was: foobar")
    public void testExtractRegionNameWithoutEncodedForm() {
        LocationNamingUtils.extractRegionId((Location)LocationNamingUtilsTest.location("foobar"));
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="region cannot be null")
    public void testEncodeRegionAndNameNullRegion() {
        LocationNamingUtils.encodeRegionIdAndName(null);
    }

    @Test
    public void testEncodeRegionAndName() {
        Assert.assertEquals((String)"1/foo", (String)LocationNamingUtils.encodeRegionIdAndName((Region)new Region(1, "foo", "bar")));
        Assert.assertEquals((String)"1/1", (String)LocationNamingUtils.encodeRegionIdAndName((Region)new Region(1, "1", "1")));
        Assert.assertEquals((String)"1///", (String)LocationNamingUtils.encodeRegionIdAndName((Region)new Region(1, "//", "1")));
    }

    private static void assertInvalidRegionIdFormat(String encoded) {
        try {
            LocationNamingUtils.extractRegionId((Location)LocationNamingUtilsTest.location(encoded));
            Assert.fail((String)("Encoded form [" + encoded + "] shouldn't produce a valid region id"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static Location location(String description) {
        return new LocationBuilder().id("location").description(description).scope(LocationScope.REGION).build();
    }
}

