/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.ImageTemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.Droplet;
import org.jclouds.digitalocean.domain.Image;
import org.jclouds.logging.Logger;

@Singleton
public class DigitalOceanImageExtension
implements ImageExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DigitalOceanApi api;
    private final Predicate<Integer> imageAvailablePredicate;
    private final Predicate<Integer> nodeStoppedPredicate;
    private final Function<Image, org.jclouds.compute.domain.Image> imageTransformer;

    @Inject
    DigitalOceanImageExtension(DigitalOceanApi api, @Named(value="jclouds.compute.timeout.image-available") Predicate<Integer> imageAvailablePredicate, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<Integer> nodeStoppedPredicate, Function<Image, org.jclouds.compute.domain.Image> imageTransformer) {
        this.api = (DigitalOceanApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
        this.imageAvailablePredicate = (Predicate)Preconditions.checkNotNull(imageAvailablePredicate, (Object)"imageAvailablePredicate cannot be null");
        this.nodeStoppedPredicate = (Predicate)Preconditions.checkNotNull(nodeStoppedPredicate, (Object)"nodeStoppedPredicate cannot be null");
        this.imageTransformer = (Function)Preconditions.checkNotNull(imageTransformer, (Object)"imageTransformer cannot be null");
    }

    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        Droplet droplet = this.api.getDropletApi().get(Integer.valueOf(id));
        if (droplet == null) {
            throw new NoSuchElementException("Cannot find droplet with id: " + id);
        }
        return new ImageTemplateBuilder.CloneImageTemplateBuilder().nodeId(id).name(name).build();
    }

    public ListenableFuture<org.jclouds.compute.domain.Image> createImage(ImageTemplate template) {
        Preconditions.checkState((boolean)(template instanceof CloneImageTemplate), (Object)"DigitalOcean only supports creating images through cloning.");
        final CloneImageTemplate cloneTemplate = (CloneImageTemplate)template;
        int powerOffEvent = this.api.getDropletApi().powerOff(Integer.parseInt(cloneTemplate.getSourceNodeId()));
        this.nodeStoppedPredicate.apply((Object)powerOffEvent);
        int snapshotEvent = this.api.getDropletApi().snapshot(Integer.parseInt(cloneTemplate.getSourceNodeId()), cloneTemplate.getName());
        this.logger.info(">> registered new Image, waiting for it to become available", new Object[0]);
        this.imageAvailablePredicate.apply((Object)snapshotEvent);
        Image snapshot = (Image)Iterables.find(this.api.getImageApi().list(), (Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                return input.getName().equals(cloneTemplate.getName());
            }
        });
        return Futures.immediateFuture((Object)this.imageTransformer.apply((Object)snapshot));
    }

    public boolean deleteImage(String id) {
        try {
            Integer imageId = Ints.tryParse((String)id);
            if (imageId != null) {
                this.logger.debug(">> image does not have a slug. Using the id to delete the image...", new Object[0]);
                this.api.getImageApi().delete(imageId);
            } else {
                this.logger.debug(">> image has a slug. Using it to delete the image...", new Object[0]);
                this.api.getImageApi().delete(id);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

