/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.compute.options.DigitalOceanTemplateOptions;
import org.jclouds.digitalocean.compute.util.LocationNamingUtils;
import org.jclouds.digitalocean.domain.Droplet;
import org.jclouds.digitalocean.domain.DropletCreation;
import org.jclouds.digitalocean.domain.Image;
import org.jclouds.digitalocean.domain.Region;
import org.jclouds.digitalocean.domain.Size;
import org.jclouds.digitalocean.domain.SshKey;
import org.jclouds.digitalocean.domain.options.CreateDropletOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshKeyPairGenerator;

public class DigitalOceanComputeServiceAdapter
implements ComputeServiceAdapter<Droplet, Size, Image, Region> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DigitalOceanApi api;
    private final SshKeyPairGenerator keyGenerator;
    private final Predicate<Integer> nodeRunningPredicate;
    private final Predicate<Integer> nodeStoppedPredicate;
    private final Predicate<Integer> nodeTerminatedPredicate;

    @Inject
    DigitalOceanComputeServiceAdapter(DigitalOceanApi api, SshKeyPairGenerator keyGenerator, @Named(value="jclouds.compute.timeout.node-running") Predicate<Integer> nodeRunningPredicate, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<Integer> nodeStoppedPredicate, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<Integer> nodeTerminatedPredicate) {
        this.api = (DigitalOceanApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
        this.keyGenerator = (SshKeyPairGenerator)Preconditions.checkNotNull((Object)keyGenerator, (Object)"keyGenerator cannot be null");
        this.nodeRunningPredicate = (Predicate)Preconditions.checkNotNull(nodeRunningPredicate, (Object)"nodeRunningPredicate cannot be null");
        this.nodeStoppedPredicate = (Predicate)Preconditions.checkNotNull(nodeStoppedPredicate, (Object)"nodeStoppedPredicate cannot be null");
        this.nodeTerminatedPredicate = (Predicate)Preconditions.checkNotNull(nodeTerminatedPredicate, (Object)"nodeTerminatedPredicate cannot be null");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Droplet> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        DigitalOceanTemplateOptions templateOptions = (DigitalOceanTemplateOptions)template.getOptions().as(DigitalOceanTemplateOptions.class);
        CreateDropletOptions.Builder options = CreateDropletOptions.builder();
        Map defaultKeys = (Map)this.keyGenerator.get();
        this.logger.debug(">> creating default keypair for node...", new Object[0]);
        SshKey defaultKey = this.api.getKeyPairApi().create(name, (String)defaultKeys.get("public"));
        this.logger.debug(">> keypair created! %s", new Object[]{defaultKey});
        options.addSshKeyId(defaultKey.getId());
        if (!Strings.isNullOrEmpty((String)template.getOptions().getPublicKey())) {
            this.logger.debug(">> creating user keypair for node...", new Object[0]);
            SshKey key = this.api.getKeyPairApi().create(name, template.getOptions().getPublicKey());
            this.logger.debug(">> keypair created! %s", new Object[]{key});
            options.addSshKeyId(key.getId());
        }
        if (!templateOptions.getSshKeyIds().isEmpty()) {
            options.addSshKeyIds(templateOptions.getSshKeyIds());
        }
        if (templateOptions.getPrivateNetworking() != null) {
            options.privateNetworking(templateOptions.getPrivateNetworking());
        }
        if (templateOptions.getBackupsEnabled() != null) {
            options.backupsEnabled(templateOptions.getBackupsEnabled());
        }
        int regionId = LocationNamingUtils.extractRegionId(template.getLocation());
        DropletCreation dropletCreation = this.api.getDropletApi().create(name, Integer.parseInt(template.getImage().getProviderId()), Integer.parseInt(template.getHardware().getProviderId()), regionId, options.build());
        this.nodeRunningPredicate.apply((Object)dropletCreation.getEventId());
        Droplet droplet = this.api.getDropletApi().get(dropletCreation.getId());
        LoginCredentials defaultCredentials = LoginCredentials.builder().user("root").privateKey((String)defaultKeys.get("private")).build();
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)droplet, String.valueOf(droplet.getId()), defaultCredentials);
    }

    public Iterable<Image> listImages() {
        return this.api.getImageApi().list();
    }

    public Iterable<Size> listHardwareProfiles() {
        return this.api.getSizesApi().list();
    }

    public Iterable<Region> listLocations() {
        return this.api.getRegionApi().list();
    }

    public Iterable<Droplet> listNodes() {
        return this.api.getDropletApi().list();
    }

    public Iterable<Droplet> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<Droplet>(){

            public boolean apply(Droplet droplet) {
                return Iterables.contains((Iterable)ids, (Object)String.valueOf(droplet.getId()));
            }
        });
    }

    public Image getImage(String id) {
        Integer imageId = Ints.tryParse((String)id);
        return imageId != null ? this.api.getImageApi().get(imageId) : this.api.getImageApi().get(id);
    }

    public Droplet getNode(String id) {
        return this.api.getDropletApi().get(Integer.valueOf(id));
    }

    public void destroyNode(String id) {
        Droplet droplet = this.api.getDropletApi().get(Integer.valueOf(id));
        final String nodeName = droplet.getName();
        int event = this.api.getDropletApi().destroy(Integer.valueOf(id), true);
        this.nodeTerminatedPredicate.apply((Object)event);
        Iterable keys = Iterables.filter(this.api.getKeyPairApi().list(), (Predicate)new Predicate<SshKey>(){

            public boolean apply(SshKey input) {
                return input.getName().equals(nodeName);
            }
        });
        for (SshKey key : keys) {
            try {
                this.logger.info(">> deleting keypair %s...", new Object[]{key});
                this.api.getKeyPairApi().delete(key.getId());
            }
            catch (RuntimeException ex) {
                this.logger.warn((Throwable)ex, ">> could not delete keypair %s. You can safely delete this key pair manually", new Object[]{key});
            }
        }
    }

    public void rebootNode(String id) {
        int event = this.api.getDropletApi().reboot(Integer.valueOf(id));
        this.nodeRunningPredicate.apply((Object)event);
    }

    public void resumeNode(String id) {
        int event = this.api.getDropletApi().powerOn(Integer.valueOf(id));
        this.nodeRunningPredicate.apply((Object)event);
    }

    public void suspendNode(String id) {
        int event = this.api.getDropletApi().powerOff(Integer.valueOf(id));
        this.nodeStoppedPredicate.apply((Object)event);
    }
}

