/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.util;

import com.google.common.base.Preconditions;
import org.jclouds.digitalocean.domain.Region;
import org.jclouds.domain.Location;

public class LocationNamingUtils {
    public static int extractRegionId(Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        String regionIdAndName = location.getDescription();
        int index = regionIdAndName.indexOf(47);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (String)"location description should be in the form 'regionId/regionName' but was: %s", (Object[])new Object[]{regionIdAndName});
        return Integer.parseInt(regionIdAndName.substring(0, index));
    }

    public static String extractRegionName(Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        String regionIdAndName = location.getDescription();
        int index = regionIdAndName.indexOf(47);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (String)"location description should be in the form 'regionId/regionName' but was: %s", (Object[])new Object[]{regionIdAndName});
        return regionIdAndName.substring(index + 1);
    }

    public static String encodeRegionIdAndName(Region region) {
        Preconditions.checkNotNull((Object)region, (Object)"region cannot be null");
        return region.getId() + "/" + region.getName();
    }
}

