/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.domain;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.digitalocean.domain.OperatingSystem;
import org.jclouds.javax.annotation.Nullable;

public class Image {
    private final int id;
    private final String name;
    private final OperatingSystem os;
    private final boolean publicImage;
    private final String slug;

    @ConstructorProperties(value={"id", "name", "distribution", "public", "slug"})
    public Image(int id, String name, String distribution, boolean publicImage, @Nullable String slug) {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.os = OperatingSystem.builder().from(name, (String)Preconditions.checkNotNull((Object)distribution, (Object)"distribution")).build();
        this.publicImage = publicImage;
        this.slug = slug;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public OperatingSystem getOs() {
        return this.os;
    }

    public boolean isPublicImage() {
        return this.publicImage;
    }

    public String getSlug() {
        return this.slug;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.os == null ? 0 : this.os.hashCode());
        result = 31 * result + (this.publicImage ? 1231 : 1237);
        result = 31 * result + (this.slug == null ? 0 : this.slug.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Image other = (Image)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.os == null ? other.os != null : !this.os.equals(other.os)) {
            return false;
        }
        if (this.publicImage != other.publicImage) {
            return false;
        }
        return !(this.slug == null ? other.slug != null : !this.slug.equals(other.slug));
    }

    public String toString() {
        return "Image [id=" + this.id + ", name=" + this.name + ", os=" + this.os + ", publicImage=" + this.publicImage + ", slug=" + this.slug + "]";
    }
}

