/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.functions;

import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.digitalocean.compute.functions.TemplateOptionsToStatementWithoutPublicKey;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.statements.ssh.InstallRSAPrivateKey;
import org.jclouds.ssh.SshKeys;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TemplateOptionsToStatementWithoutPublicKeyTest")
public class TemplateOptionsToStatementWithoutPublicKeyTest {
    @Test
    public void testPublicKeyDoesNotGenerateAuthorizePublicKeyStatementIfOnlyPublicKeyOptionsConfigured() {
        Map keys = SshKeys.generate();
        TemplateOptions options = TemplateOptions.Builder.authorizePublicKey((String)((String)keys.get("public")));
        TemplateOptionsToStatementWithoutPublicKey function = new TemplateOptionsToStatementWithoutPublicKey();
        Assert.assertNull((Object)function.apply(options));
    }

    @Test
    public void testPublicAndRunScriptKeyDoesNotGenerateAuthorizePublicKeyStatementIfRunScriptPresent() {
        Map keys = SshKeys.generate();
        TemplateOptions options = TemplateOptions.Builder.authorizePublicKey((String)((String)keys.get("public"))).runScript("uptime");
        TemplateOptionsToStatementWithoutPublicKey function = new TemplateOptionsToStatementWithoutPublicKey();
        Statement statement = function.apply(options);
        Assert.assertEquals((String)statement.render(OsFamily.UNIX), (String)"uptime\n");
    }

    @Test
    public void testPublicAndPrivateKeyAndRunScriptDoesNotGenerateAuthorizePublicKeyStatementIfOtherOptionsPresent() {
        Map keys = SshKeys.generate();
        TemplateOptions options = TemplateOptions.Builder.authorizePublicKey((String)((String)keys.get("public"))).installPrivateKey((String)keys.get("private")).runScript("uptime");
        TemplateOptionsToStatementWithoutPublicKey function = new TemplateOptionsToStatementWithoutPublicKey();
        Statement statement = function.apply(options);
        Assert.assertTrue((boolean)(statement instanceof StatementList));
        StatementList statements = (StatementList)statement;
        Assert.assertEquals((int)statements.size(), (int)2);
        Assert.assertEquals((String)((Statement)statements.get(0)).render(OsFamily.UNIX), (String)"uptime\n");
        Assert.assertTrue((boolean)(statements.get(1) instanceof InstallRSAPrivateKey));
    }
}

