/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.predicates;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import org.jclouds.digitalocean.domain.SshKey;
import org.jclouds.digitalocean.predicates.SameFingerprint;
import org.jclouds.digitalocean.ssh.DSAKeys;
import org.jclouds.ssh.SshKeys;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SameFingerprintTest")
public class SameFingerprintTest {
    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="key cannot be null")
    public void testPublicKeyCannotBeNull() {
        new SameFingerprint(null);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="public key cannot be null")
    public void testPublicKeyInSshKeyCannotBeNull() throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        String rsa = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/ssh-rsa.txt"));
        PublicKey key = KeyFactory.getInstance("RSA").generatePublic(SshKeys.publicKeySpecFromOpenSSH((String)rsa));
        SameFingerprint predicate = new SameFingerprint(key);
        predicate.apply(new SshKey(0, "foo", null));
    }

    @Test
    public void testSameFingerPrintRSA() throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        String rsa = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/ssh-rsa.txt"));
        PublicKey key = KeyFactory.getInstance("RSA").generatePublic(SshKeys.publicKeySpecFromOpenSSH((String)rsa));
        SameFingerprint predicate = new SameFingerprint(key);
        Assert.assertTrue((boolean)predicate.apply(new SshKey(0, "foo", key)));
    }

    @Test
    public void testSameFingerPrintDSA() throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        String dsa = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/ssh-dsa.txt"));
        PublicKey key = KeyFactory.getInstance("DSA").generatePublic(DSAKeys.publicKeySpecFromOpenSSH((String)dsa));
        SameFingerprint predicate = new SameFingerprint(key);
        Assert.assertTrue((boolean)predicate.apply(new SshKey(0, "foo", key)));
    }
}

