/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.strategy;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.SshKey;
import org.jclouds.digitalocean.internal.BaseDigitalOceanLiveTest;
import org.jclouds.digitalocean.strategy.ListSshKeys;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ListSshKeysLiveTest")
public class ListSshKeysLiveTest
extends BaseDigitalOceanLiveTest {
    private ListSshKeys strategy;
    private SshKey rsaKey;
    private SshKey dsaKey;

    protected void initialize() {
        super.initialize();
        this.strategy = new ListSshKeys((DigitalOceanApi)this.api, MoreExecutors.sameThreadExecutor());
    }

    @BeforeClass
    public void setupKeys() throws IOException {
        String rsa = Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/ssh-rsa.txt"));
        String dsa = Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/ssh-dsa.txt"));
        this.rsaKey = ((DigitalOceanApi)this.api).getKeyPairApi().create("jclouds-test-rsa", rsa);
        this.dsaKey = ((DigitalOceanApi)this.api).getKeyPairApi().create("jclouds-test-dsa", dsa);
    }

    @AfterClass(alwaysRun=true)
    public void cleanupKeys() {
        if (this.rsaKey != null) {
            ((DigitalOceanApi)this.api).getKeyPairApi().delete(this.rsaKey.getId());
        }
        if (this.dsaKey != null) {
            ((DigitalOceanApi)this.api).getKeyPairApi().delete(this.dsaKey.getId());
        }
    }

    public void testListWithDetails() {
        List keys = this.strategy.execute();
        Assert.assertTrue((keys.size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)keys, (Predicate)new Predicate<SshKey>(){

            public boolean apply(SshKey input) {
                return input.getPublicKey() != null;
            }
        }));
    }
}

