/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.digitalocean.compute.util.LocationNamingUtils;
import org.jclouds.digitalocean.domain.Droplet;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

@Singleton
public class DropletToNodeMetadata
implements Function<Droplet, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<Map<String, ? extends Image>> images;
    private final Supplier<Map<String, ? extends Hardware>> hardwares;
    private final Supplier<Set<? extends Location>> locations;
    private final Function<Droplet.Status, NodeMetadata.Status> toPortableStatus;
    private final GroupNamingConvention groupNamingConvention;
    private final Map<String, Credentials> credentialStore;

    @Inject
    DropletToNodeMetadata(Supplier<Map<String, ? extends Image>> images, Supplier<Map<String, ? extends Hardware>> hardwares, @Memoized Supplier<Set<? extends Location>> locations, Function<Droplet.Status, NodeMetadata.Status> toPortableStatus, GroupNamingConvention.Factory groupNamingConvention, Map<String, Credentials> credentialStore) {
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images cannot be null");
        this.hardwares = (Supplier)Preconditions.checkNotNull(hardwares, (Object)"hardwares cannot be null");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations cannot be null");
        this.toPortableStatus = (Function)Preconditions.checkNotNull(toPortableStatus, (Object)"toPortableStatus cannot be null");
        this.groupNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)groupNamingConvention, (Object)"groupNamingConvention cannot be null")).createWithoutPrefix();
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore cannot be null");
    }

    public NodeMetadata apply(Droplet input) {
        Credentials credentials;
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(String.valueOf(input.getId()));
        builder.name(input.getName());
        builder.hostname(input.getName());
        builder.group(this.groupNamingConvention.extractGroup(input.getName()));
        builder.hardware(this.getHardware(input.getSizeId()));
        builder.location(this.getLocation(input.getRegionId()));
        Optional<? extends Image> image = this.findImage(input.getImageId());
        if (image.isPresent()) {
            builder.imageId(((Image)image.get()).getId());
            builder.operatingSystem(((Image)image.get()).getOperatingSystem());
        } else {
            this.logger.info(">> image with id %s for droplet %s was not found. This might be because the image that was used to create the droplet has a new id.", new Object[]{input.getImageId(), input.getId()});
        }
        builder.status((NodeMetadata.Status)this.toPortableStatus.apply((Object)input.getStatus()));
        builder.backendStatus(input.getStatus().name());
        if (input.getIp() != null) {
            builder.publicAddresses((Iterable)ImmutableSet.of((Object)input.getIp()));
        }
        if (input.getPrivateIp() != null) {
            builder.privateAddresses((Iterable)ImmutableSet.of((Object)input.getPrivateIp()));
        }
        if ((credentials = this.credentialStore.get("node#" + input.getId())) instanceof LoginCredentials) {
            builder.credentials((LoginCredentials)LoginCredentials.class.cast(credentials));
        }
        return builder.build();
    }

    protected Optional<? extends Image> findImage(Integer id) {
        final String imageId = String.valueOf(id);
        Optional image = Optional.fromNullable(((Map)this.images.get()).get(imageId));
        if (!image.isPresent()) {
            image = Iterables.tryFind(((Map)this.images.get()).values(), (Predicate)new Predicate<Image>(){

                public boolean apply(Image input) {
                    return input.getProviderId().equals(imageId);
                }
            });
        }
        return image;
    }

    protected Hardware getHardware(Integer id) {
        final String hardwareId = String.valueOf(id);
        return (Hardware)Iterables.find(((Map)this.hardwares.get()).values(), (Predicate)new Predicate<Hardware>(){

            public boolean apply(Hardware input) {
                return input.getProviderId().equals(hardwareId);
            }
        });
    }

    protected Location getLocation(final Integer id) {
        return (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)new Predicate<Location>(){

            public boolean apply(Location location) {
                return id.equals(LocationNamingUtils.extractRegionId(location));
            }
        });
    }
}

