/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.digitalocean.domain.Size;

@Singleton
public class SizeToHardware
implements Function<Size, Hardware> {
    public Hardware apply(Size input) {
        HardwareBuilder builder = new HardwareBuilder();
        builder.id(input.getSlug());
        builder.providerId(String.valueOf(input.getId()));
        builder.name(input.getName());
        builder.ram(input.getMemory());
        builder.processor(new Processor((double)input.getCpu(), (double)input.getCpu()));
        builder.volume(new VolumeBuilder().size(Float.valueOf(input.getDisk())).type(Volume.Type.LOCAL).build());
        ImmutableMap.Builder metadata = ImmutableMap.builder();
        metadata.put((Object)"costPerHour", (Object)input.getCostPerHour());
        metadata.put((Object)"costPerMonth", (Object)input.getCostPerMonth());
        builder.userMetadata((Map)metadata.build());
        return builder.build();
    }
}

