/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;

public class DigitalOceanTemplateOptions
extends TemplateOptions
implements Cloneable {
    private Set<Integer> sshKeyIds = ImmutableSet.of();
    private Boolean privateNetworking;
    private Boolean backupsEnabled;
    private boolean autoCreateKeyPair = true;

    public DigitalOceanTemplateOptions privateNetworking(boolean privateNetworking) {
        this.privateNetworking = privateNetworking;
        return this;
    }

    public DigitalOceanTemplateOptions backupsEnabled(boolean backupsEnabled) {
        this.backupsEnabled = backupsEnabled;
        return this;
    }

    public DigitalOceanTemplateOptions sshKeyIds(Iterable<Integer> sshKeyIds) {
        this.sshKeyIds = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(sshKeyIds, (Object)"sshKeyIds cannot be null")));
        return this;
    }

    public DigitalOceanTemplateOptions autoCreateKeyPair(boolean autoCreateKeyPair) {
        this.autoCreateKeyPair = autoCreateKeyPair;
        return this;
    }

    public Set<Integer> getSshKeyIds() {
        return this.sshKeyIds;
    }

    public Boolean getPrivateNetworking() {
        return this.privateNetworking;
    }

    public Boolean getBackupsEnabled() {
        return this.backupsEnabled;
    }

    public boolean getAutoCreateKeyPair() {
        return this.autoCreateKeyPair;
    }

    public DigitalOceanTemplateOptions clone() {
        DigitalOceanTemplateOptions options = new DigitalOceanTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof DigitalOceanTemplateOptions) {
            DigitalOceanTemplateOptions eTo = (DigitalOceanTemplateOptions)DigitalOceanTemplateOptions.class.cast(to);
            if (this.privateNetworking != null) {
                eTo.privateNetworking(this.privateNetworking);
            }
            if (this.backupsEnabled != null) {
                eTo.backupsEnabled(this.backupsEnabled);
            }
            eTo.autoCreateKeyPair(this.autoCreateKeyPair);
            eTo.sshKeyIds(this.sshKeyIds);
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.backupsEnabled, this.privateNetworking, this.autoCreateKeyPair, this.sshKeyIds});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DigitalOceanTemplateOptions other = (DigitalOceanTemplateOptions)obj;
        return super.equals((Object)other) && Objects.equal((Object)this.backupsEnabled, (Object)other.backupsEnabled) && Objects.equal((Object)this.privateNetworking, (Object)other.privateNetworking) && Objects.equal((Object)this.autoCreateKeyPair, (Object)other.autoCreateKeyPair) && Objects.equal(this.sshKeyIds, other.sshKeyIds);
    }

    public Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = super.string().omitNullValues();
        toString.add("privateNetworking", (Object)this.privateNetworking);
        toString.add("backupsEnabled", (Object)this.backupsEnabled);
        if (!this.sshKeyIds.isEmpty()) {
            toString.add("sshKeyIds", this.sshKeyIds);
        }
        toString.add("autoCreateKeyPair", this.autoCreateKeyPair);
        return toString;
    }

    public static class Builder {
        public static DigitalOceanTemplateOptions privateNetworking(boolean privateNetworking) {
            DigitalOceanTemplateOptions options = new DigitalOceanTemplateOptions();
            return options.privateNetworking(privateNetworking);
        }

        public static DigitalOceanTemplateOptions backupsEnabled(boolean backupsEnabled) {
            DigitalOceanTemplateOptions options = new DigitalOceanTemplateOptions();
            return options.backupsEnabled(backupsEnabled);
        }

        public static DigitalOceanTemplateOptions sshKeyIds(Iterable<Integer> sshKeyIds) {
            DigitalOceanTemplateOptions options = new DigitalOceanTemplateOptions();
            return options.sshKeyIds(sshKeyIds);
        }

        public static DigitalOceanTemplateOptions autoCreateKeyPair(boolean autoCreateKeyPair) {
            DigitalOceanTemplateOptions options = new DigitalOceanTemplateOptions();
            return options.autoCreateKeyPair(autoCreateKeyPair);
        }
    }
}

