/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.compute.options.DigitalOceanTemplateOptions;
import org.jclouds.digitalocean.domain.SshKey;
import org.jclouds.digitalocean.predicates.SameFingerprint;
import org.jclouds.digitalocean.strategy.ListSshKeys;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshKeyPairGenerator;

@Singleton
public class CreateKeyPairsThenCreateNodes
extends CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DigitalOceanApi api;
    private final SshKeyPairGenerator keyGenerator;
    private final ListSshKeys listSshKeys;
    private final Function<String, PublicKey> sshKeyToPublicKey;

    @Inject
    protected CreateKeyPairsThenCreateNodes(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, DigitalOceanApi api, SshKeyPairGenerator keyGenerator, ListSshKeys.Factory listSshKeysFactory, Function<String, PublicKey> sshKeyToPublicKey) {
        super(addNodeWithGroupStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.api = (DigitalOceanApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
        this.keyGenerator = (SshKeyPairGenerator)Preconditions.checkNotNull((Object)keyGenerator, (Object)"keyGenerator cannot be null");
        Preconditions.checkNotNull((Object)listSshKeysFactory, (Object)"listSshKeysFactory cannot be null");
        Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor cannot be null");
        this.listSshKeys = listSshKeysFactory.create(userExecutor);
        this.sshKeyToPublicKey = (Function)Preconditions.checkNotNull(sshKeyToPublicKey, (Object)"sshKeyToPublicKey cannot be null");
    }

    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        DigitalOceanTemplateOptions options = (DigitalOceanTemplateOptions)template.getOptions().as(DigitalOceanTemplateOptions.class);
        HashSet generatedSshKeyIds = Sets.newHashSet();
        if (options.getSshKeyIds().isEmpty() && options.getAutoCreateKeyPair() && Strings.isNullOrEmpty((String)options.getPublicKey())) {
            this.generateKeyPairAndAddKeyToSet(options, generatedSshKeyIds);
        }
        if (options.getRunScript() != null) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)options.getLoginPrivateKey()) ? 1 : 0) != 0, (String)"no private key configured for: %s; please use options.overrideLoginPrivateKey(rsa_private_text)", (Object[])new Object[]{group});
        }
        if (!Strings.isNullOrEmpty((String)options.getPublicKey())) {
            this.createKeyPairForPublicKeyInOptionsAndAddToSet(options, generatedSshKeyIds);
        }
        options.sshKeyIds((Iterable<Integer>)Sets.union((Set)generatedSshKeyIds, options.getSshKeyIds()));
        Map responses = super.execute(group, count, template, goodNodes, badNodes, customizationResponses);
        this.registerAutoGeneratedKeyPairCleanupCallbacks(responses, generatedSshKeyIds);
        return responses;
    }

    private void createKeyPairForPublicKeyInOptionsAndAddToSet(DigitalOceanTemplateOptions options, Set<Integer> generatedSshKeyIds) {
        this.logger.debug(">> checking if the key pair already exists...", new Object[0]);
        PublicKey userKey = (PublicKey)this.sshKeyToPublicKey.apply((Object)options.getPublicKey());
        Optional key = Iterables.tryFind(this.listSshKeys.execute(), (Predicate)new SameFingerprint(userKey));
        if (!key.isPresent()) {
            this.logger.debug(">> key pair not found. creating a new one...", new Object[0]);
            String userFingerprint = SameFingerprint.computeFingerprint(userKey);
            SshKey newKey = this.api.getKeyPairApi().create(userFingerprint, options.getPublicKey());
            generatedSshKeyIds.add(newKey.getId());
            this.logger.debug(">> key pair created! %s", new Object[]{newKey});
        } else {
            this.logger.debug(">> key pair found! %s", new Object[]{key.get()});
            generatedSshKeyIds.add(((SshKey)key.get()).getId());
        }
    }

    private void generateKeyPairAndAddKeyToSet(DigitalOceanTemplateOptions options, Set<Integer> generatedSshKeyIds) {
        this.logger.debug(">> creating default keypair for node...", new Object[0]);
        Map defaultKeys = (Map)this.keyGenerator.get();
        PublicKey defaultPublicKey = (PublicKey)this.sshKeyToPublicKey.apply(defaultKeys.get("public"));
        String fingerprint = SameFingerprint.computeFingerprint(defaultPublicKey);
        SshKey defaultKey = this.api.getKeyPairApi().create(fingerprint, (String)defaultKeys.get("public"));
        generatedSshKeyIds.add(defaultKey.getId());
        this.logger.debug(">> keypair created! %s", new Object[]{defaultKey});
        if (Strings.isNullOrEmpty((String)options.getLoginPrivateKey())) {
            options.overrideLoginPrivateKey((String)defaultKeys.get("private"));
        }
    }

    private void registerAutoGeneratedKeyPairCleanupCallbacks(Map<?, ListenableFuture<Void>> responses, final Set<Integer> generatedSshKeyIds) {
        ListenableFuture aggregatedResponses = Futures.successfulAsList(responses.values());
        Futures.addCallback((ListenableFuture)aggregatedResponses, (FutureCallback)new FutureCallback<List<Void>>(){

            public void onSuccess(List<Void> result) {
                this.cleanupAutoGeneratedKeyPairs(generatedSshKeyIds);
            }

            public void onFailure(Throwable t) {
                this.cleanupAutoGeneratedKeyPairs(generatedSshKeyIds);
            }

            private void cleanupAutoGeneratedKeyPairs(Set<Integer> generatedSshKeyIds2) {
                CreateKeyPairsThenCreateNodes.this.logger.debug(">> cleaning up auto-generated key pairs...", new Object[0]);
                for (Integer sshKeyId : generatedSshKeyIds2) {
                    try {
                        CreateKeyPairsThenCreateNodes.this.api.getKeyPairApi().delete(sshKeyId);
                    }
                    catch (Exception ex) {
                        CreateKeyPairsThenCreateNodes.this.logger.warn(">> could not delete key pair %s: %s", new Object[]{sshKeyId, ex.getMessage()});
                    }
                }
            }
        }, (Executor)this.userExecutor);
    }
}

