/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.compute.options.DigitalOceanTemplateOptions;
import org.jclouds.digitalocean.compute.util.LocationNamingUtils;
import org.jclouds.digitalocean.domain.Droplet;
import org.jclouds.digitalocean.domain.DropletCreation;
import org.jclouds.digitalocean.domain.Image;
import org.jclouds.digitalocean.domain.Region;
import org.jclouds.digitalocean.domain.Size;
import org.jclouds.digitalocean.domain.options.CreateDropletOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

public class DigitalOceanComputeServiceAdapter
implements ComputeServiceAdapter<Droplet, Size, Image, Region> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DigitalOceanApi api;
    private final Predicate<Integer> nodeRunningPredicate;
    private final Predicate<Integer> nodeStoppedPredicate;
    private final Predicate<Integer> nodeTerminatedPredicate;

    @Inject
    DigitalOceanComputeServiceAdapter(DigitalOceanApi api, @Named(value="jclouds.compute.timeout.node-running") Predicate<Integer> nodeRunningPredicate, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<Integer> nodeStoppedPredicate, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<Integer> nodeTerminatedPredicate) {
        this.api = (DigitalOceanApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
        this.nodeRunningPredicate = (Predicate)Preconditions.checkNotNull(nodeRunningPredicate, (Object)"nodeRunningPredicate cannot be null");
        this.nodeStoppedPredicate = (Predicate)Preconditions.checkNotNull(nodeStoppedPredicate, (Object)"nodeStoppedPredicate cannot be null");
        this.nodeTerminatedPredicate = (Predicate)Preconditions.checkNotNull(nodeTerminatedPredicate, (Object)"nodeTerminatedPredicate cannot be null");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Droplet> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        DigitalOceanTemplateOptions templateOptions = (DigitalOceanTemplateOptions)template.getOptions().as(DigitalOceanTemplateOptions.class);
        CreateDropletOptions.Builder options = CreateDropletOptions.builder();
        if (!templateOptions.getSshKeyIds().isEmpty()) {
            options.addSshKeyIds(templateOptions.getSshKeyIds());
        }
        if (templateOptions.getPrivateNetworking() != null) {
            options.privateNetworking(templateOptions.getPrivateNetworking());
        }
        if (templateOptions.getBackupsEnabled() != null) {
            options.backupsEnabled(templateOptions.getBackupsEnabled());
        }
        int regionId = LocationNamingUtils.extractRegionId(template.getLocation());
        DropletCreation dropletCreation = this.api.getDropletApi().create(name, Integer.parseInt(template.getImage().getProviderId()), Integer.parseInt(template.getHardware().getProviderId()), regionId, options.build());
        this.nodeRunningPredicate.apply((Object)dropletCreation.getEventId());
        Droplet droplet = this.api.getDropletApi().get(dropletCreation.getId());
        LoginCredentials defaultCredentials = LoginCredentials.builder().user("root").privateKey(templateOptions.getLoginPrivateKey()).build();
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)droplet, String.valueOf(droplet.getId()), defaultCredentials);
    }

    public Iterable<Image> listImages() {
        return this.api.getImageApi().list();
    }

    public Iterable<Size> listHardwareProfiles() {
        return this.api.getSizesApi().list();
    }

    public Iterable<Region> listLocations() {
        return this.api.getRegionApi().list();
    }

    public Iterable<Droplet> listNodes() {
        return this.api.getDropletApi().list();
    }

    public Iterable<Droplet> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<Droplet>(){

            public boolean apply(Droplet droplet) {
                return Iterables.contains((Iterable)ids, (Object)String.valueOf(droplet.getId()));
            }
        });
    }

    public Image getImage(String id) {
        Integer imageId = Ints.tryParse((String)id);
        return imageId != null ? this.api.getImageApi().get(imageId) : this.api.getImageApi().get(id);
    }

    public Droplet getNode(String id) {
        return this.api.getDropletApi().get(Integer.valueOf(id));
    }

    public void destroyNode(String id) {
        int event = this.api.getDropletApi().destroy(Integer.valueOf(id), true);
        this.nodeTerminatedPredicate.apply((Object)event);
    }

    public void rebootNode(String id) {
        int event = this.api.getDropletApi().reboot(Integer.valueOf(id));
        this.nodeRunningPredicate.apply((Object)event);
    }

    public void resumeNode(String id) {
        int event = this.api.getDropletApi().powerOn(Integer.valueOf(id));
        this.nodeRunningPredicate.apply((Object)event);
    }

    public void suspendNode(String id) {
        int event = this.api.getDropletApi().powerOff(Integer.valueOf(id));
        this.nodeStoppedPredicate.apply((Object)event);
    }
}

