/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.domain;

import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.inject.name.Named;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class Event {
    private final int id;
    @Named(value="action_status")
    private final Status status;
    @Named(value="event_type_id")
    private final int typeId;
    private final Integer percentage;
    @Named(value="droplet_id")
    private final int dropletId;

    @ConstructorProperties(value={"id", "action_status", "event_type_id", "percentage", "droplet_id"})
    public Event(int id, @Nullable Status status, int typeId, @Nullable String percentage, int dropletId) {
        this.id = id;
        this.status = status == null ? Status.PENDING : status;
        this.typeId = typeId;
        this.percentage = percentage == null ? null : Ints.tryParse((String)percentage);
        this.dropletId = dropletId;
    }

    public int getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public Integer getPercentage() {
        return this.percentage;
    }

    public int getDropletId() {
        return this.dropletId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dropletId;
        result = 31 * result + this.id;
        result = 31 * result + (this.percentage == null ? 0 : this.percentage.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + this.typeId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        if (this.dropletId != other.dropletId) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.percentage == null ? other.percentage != null : !this.percentage.equals(other.percentage)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.typeId == other.typeId;
    }

    public String toString() {
        return "Event [id=" + this.id + ", status=" + (Object)((Object)this.status) + ", typeId=" + this.typeId + ", percentage=" + this.percentage + ", dropletId=" + this.dropletId + "]";
    }

    public static enum Status {
        DONE,
        PENDING,
        ERROR;


        public static Status fromValue(String value) {
            if (value == null) {
                return PENDING;
            }
            Optional status = Enums.getIfPresent(Status.class, (String)value.toUpperCase());
            Preconditions.checkArgument((boolean)status.isPresent(), (String)"Expected one of %s but was", (Object[])new Object[]{Joiner.on((char)',').join((Object[])Status.values()), value});
            return (Status)((Object)status.get());
        }
    }
}

