/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.domain;

import com.google.common.base.Preconditions;
import com.google.inject.name.Named;
import java.beans.ConstructorProperties;
import java.security.PublicKey;
import org.jclouds.javax.annotation.Nullable;

public class SshKey {
    private final int id;
    private final String name;
    @Named(value="ssh_pub_key")
    private final PublicKey publicKey;

    @ConstructorProperties(value={"id", "name", "ssh_pub_key"})
    public SshKey(int id, String name, @Nullable PublicKey publicKey) {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.publicKey = publicKey;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SshKey other = (SshKey)obj;
        if (this.id != other.id) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "SshKey [id=" + this.id + ", name=" + this.name + ", publicKey=" + this.publicKey + "]";
    }
}

