/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.features;

import com.google.inject.name.Named;
import java.io.Closeable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.digitalocean.domain.SshKey;
import org.jclouds.digitalocean.http.filters.AuthenticationFilter;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@Consumes(value={"application/json"})
@Path(value="/ssh_keys")
public interface KeyPairApi
extends Closeable {
    @Named(value="key:list")
    @GET
    @SelectJson(value={"ssh_keys"})
    public List<SshKey> list();

    @Named(value="key:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"ssh_key"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SshKey get(@PathParam(value="id") int var1);

    @Named(value="key:create")
    @GET
    @Path(value="/new")
    @SelectJson(value={"ssh_key"})
    public SshKey create(@QueryParam(value="name") String var1, @QueryParam(value="ssh_pub_key") String var2);

    @Named(value="key:edit")
    @GET
    @Path(value="/{id}/edit")
    @SelectJson(value={"ssh_key"})
    public SshKey edit(@PathParam(value="id") int var1, @QueryParam(value="ssh_pub_key") String var2);

    @Named(value="key:delete")
    @GET
    @Path(value="/{id}/destroy")
    public void delete(@PathParam(value="id") int var1);
}

