/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.http;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jclouds.digitalocean.domain.BaseResponse;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.http.internal.JavaUrlHttpCommandExecutorService;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;

@Singleton
public class ResponseStatusFromPayloadHttpCommandExecutorService
extends JavaUrlHttpCommandExecutorService {
    public static final String ACCESS_DENIED = "Access Denied";
    public static final String NOT_FOUND = "Not Found";
    private final ParseJson<BaseResponse> errorParser;

    @Inject
    ResponseStatusFromPayloadHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, @Named(value="untrusted") HostnameVerifier verifier, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider, Function<URI, Proxy> proxyForURI, ParseJson<BaseResponse> errorParser) throws SecurityException, NoSuchFieldException {
        super(utils, contentMetadataCodec, retryHandler, ioRetryHandler, errorHandler, wire, verifier, untrustedSSLContextProvider, proxyForURI);
        this.errorParser = (ParseJson)Preconditions.checkNotNull(errorParser, (Object)"errorParser cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse invoke(HttpURLConnection connection) throws IOException, InterruptedException {
        HttpResponse original = super.invoke(connection);
        HttpResponse.Builder response = original.toBuilder();
        if (ResponseStatusFromPayloadHttpCommandExecutorService.hasPayload(original)) {
            InputStream in = null;
            InputStream originalInputStream = original.getPayload().openStream();
            if (originalInputStream instanceof ByteArrayInputStream) {
                in = originalInputStream;
            } else {
                try {
                    in = new ByteArrayInputStream(ByteStreams.toByteArray((InputStream)originalInputStream));
                }
                finally {
                    Closeables.close((Closeable)originalInputStream, (boolean)true);
                }
            }
            BaseResponse responseContent = (BaseResponse)this.errorParser.apply(in);
            if (responseContent != null && responseContent.getStatus() == BaseResponse.Status.ERROR) {
                String message = responseContent.getMessage();
                if (ACCESS_DENIED.equals(message)) {
                    response.statusCode(401);
                } else if (NOT_FOUND.equals(message)) {
                    response.statusCode(404);
                } else {
                    response.statusCode(500);
                }
                response.message(responseContent.getDetails());
            }
            in.reset();
            InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)in);
            this.contentMetadataCodec.fromHeaders(payload.getContentMetadata(), original.getHeaders());
            response.payload((Payload)payload);
        }
        return response.build();
    }

    private static boolean hasPayload(HttpResponse response) {
        return response.getPayload() != null && response.getPayload().getRawContent() != null;
    }
}

