/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.jclouds.digitalocean.domain.SshKey;
import org.jclouds.digitalocean.ssh.DSAKeys;
import org.jclouds.ssh.SshKeys;

public class SameFingerprint
implements Predicate<SshKey> {
    public final String fingerprint;

    public SameFingerprint(PublicKey key) {
        this.fingerprint = SameFingerprint.computeFingerprint((PublicKey)Preconditions.checkNotNull((Object)key, (Object)"key cannot be null"));
    }

    public boolean apply(SshKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        Preconditions.checkNotNull((Object)key.getPublicKey(), (Object)"public key cannot be null");
        return this.fingerprint.equals(SameFingerprint.computeFingerprint(key.getPublicKey()));
    }

    public static String computeFingerprint(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            return SshKeys.fingerprint((BigInteger)rsaKey.getPublicExponent(), (BigInteger)rsaKey.getModulus());
        }
        if (key instanceof DSAPublicKey) {
            DSAPublicKey dsaKey = (DSAPublicKey)key;
            return DSAKeys.fingerprint(dsaKey.getParams().getP(), dsaKey.getParams().getQ(), dsaKey.getParams().getG(), dsaKey.getY());
        }
        throw new IllegalArgumentException("Only RSA and DSA keys are supported");
    }
}

