/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.digitalocean.DigitalOceanApi;
import org.jclouds.digitalocean.domain.SshKey;
import org.jclouds.digitalocean.features.KeyPairApi;

@Singleton
public class ListSshKeys {
    private final KeyPairApi keyPairApi;
    private final ListeningExecutorService executor;

    @Inject
    ListSshKeys(DigitalOceanApi api, @Assisted ListeningExecutorService executor) {
        Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
        this.executor = (ListeningExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor cannot be null");
        this.keyPairApi = api.getKeyPairApi();
    }

    public List<SshKey> execute() {
        List<SshKey> keys = this.keyPairApi.list();
        ListenableFuture futures = Futures.allAsList((Iterable)Iterables.transform(keys, (Function)new Function<SshKey, ListenableFuture<SshKey>>(){

            public ListenableFuture<SshKey> apply(final SshKey input) {
                return ListSshKeys.this.executor.submit((Callable)new Callable<SshKey>(){

                    @Override
                    public SshKey call() throws Exception {
                        return ListSshKeys.this.keyPairApi.get(input.getId());
                    }
                });
            }
        }));
        return (List)Futures.getUnchecked((Future)futures);
    }

    public static interface Factory {
        public ListSshKeys create(ListeningExecutorService var1);
    }
}

