/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.glance.v1_0.features;

import java.io.InputStream;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.glance.v1_0.domain.Image;
import org.jclouds.openstack.glance.v1_0.domain.ImageDetails;
import org.jclouds.openstack.glance.v1_0.functions.ParseImageDetailsFromHeaders;
import org.jclouds.openstack.glance.v1_0.functions.internal.ParseImageDetails;
import org.jclouds.openstack.glance.v1_0.functions.internal.ParseImages;
import org.jclouds.openstack.glance.v1_0.options.CreateImageOptions;
import org.jclouds.openstack.glance.v1_0.options.ListImageOptions;
import org.jclouds.openstack.glance.v1_0.options.UpdateImageOptions;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@Consumes(value={"application/json"})
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/images")
public interface ImageApi {
    @Named(value="image:list")
    @GET
    @ResponseParser(value=ParseImages.class)
    @Transform(value=ParseImages.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Image> list();

    @Named(value="image:list")
    @GET
    @ResponseParser(value=ParseImages.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PaginatedCollection<Image> list(ListImageOptions var1);

    @Named(value="image:listInDetail")
    @GET
    @Path(value="/detail")
    @ResponseParser(value=ParseImageDetails.class)
    @Transform(value=ParseImageDetails.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<ImageDetails> listInDetail();

    @Named(value="image:listInDetail")
    @GET
    @Path(value="/detail")
    @ResponseParser(value=ParseImageDetails.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PaginatedCollection<ImageDetails> listInDetail(ListImageOptions var1);

    @Named(value="image:get")
    @HEAD
    @Path(value="/{id}")
    @ResponseParser(value=ParseImageDetailsFromHeaders.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public ImageDetails get(@PathParam(value="id") String var1);

    @Named(value="image:getAsStream")
    @GET
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public InputStream getAsStream(@PathParam(value="id") String var1);

    @Named(value="image:create")
    @POST
    @Produces(value={"application/octet-stream"})
    @SelectJson(value={"image"})
    public ImageDetails create(@HeaderParam(value="x-image-meta-name") String var1, Payload var2, CreateImageOptions ... var3);

    @Named(value="image:reserve")
    @POST
    @SelectJson(value={"image"})
    public ImageDetails reserve(@HeaderParam(value="x-image-meta-name") String var1, CreateImageOptions ... var2);

    @Named(value="image:upload")
    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/octet-stream"})
    @SelectJson(value={"image"})
    public ImageDetails upload(@PathParam(value="id") String var1, Payload var2, UpdateImageOptions ... var3);

    @Named(value="image:update")
    @PUT
    @Path(value="/{id}")
    @SelectJson(value={"image"})
    public ImageDetails update(@PathParam(value="id") String var1, UpdateImageOptions ... var2);

    @Named(value="image:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

