/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class BaseAWSReservationHandler<T>
extends ParseSax.HandlerForGeneratedRequestWithResult<T> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final DateService dateService;
    protected final Supplier<String> defaultRegion;
    protected AWSRunningInstance.Builder builder = this.newBuilder();
    protected StringBuilder currentText = new StringBuilder();
    protected int itemDepth;
    boolean inInstancesSet;
    private String volumeId;
    private Attachment.Status attachmentStatus;
    private Date attachTime;
    private boolean deleteOnTermination;
    private String deviceName;
    private String groupId;
    private Map<String, String> reservationGroupIdToNames = Maps.newLinkedHashMap();
    private String ownerId;
    private String requesterId;
    private String reservationId;
    private Set<RunningInstance> instances = Sets.newLinkedHashSet();
    private boolean inPlacement;
    private boolean inIamInstanceProfile;

    protected BaseAWSReservationHandler(DateService dateService, @Region Supplier<String> defaultRegion) {
        this.dateService = dateService;
        this.defaultRegion = defaultRegion;
    }

    protected AWSRunningInstance.Builder newBuilder() {
        return AWSRunningInstance.builder();
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            ++this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instancesSet")) {
            this.inInstancesSet = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"placement")) {
            this.inPlacement = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"iamInstanceProfile")) {
            this.inIamInstanceProfile = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            this.inItem();
            --this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"state")) {
            this.builder.monitoringState(MonitoringState.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupId")) {
            this.groupId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupName") && this.inPlacement) {
            this.builder.placementGroup(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"arn") && this.inIamInstanceProfile) {
            this.builder.iamInstanceProfileArn(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"id") && this.inIamInstanceProfile) {
            this.builder.iamInstanceProfileId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupName")) {
            switch (this.itemDepth) {
                case 2: {
                    this.reservationGroupIdToNames.put(this.groupId, SaxUtils.currentOrNull((StringBuilder)this.currentText));
                    break;
                }
                case 3: {
                    this.builder.securityGroupIdToName(this.groupId, SaxUtils.currentOrNull((StringBuilder)this.currentText));
                }
            }
            this.groupId = null;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"subnetId")) {
            this.builder.subnetId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"spotInstanceRequestId")) {
            this.builder.spotInstanceRequestId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"vpcId")) {
            this.builder.vpcId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"hypervisor")) {
            this.builder.hypervisor(Hypervisor.fromValue((String)SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"productCode")) {
            this.builder.productCode(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instancesSet")) {
            this.inInstancesSet = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"placement")) {
            this.inPlacement = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"iamInstanceProfile")) {
            this.inIamInstanceProfile = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ownerId")) {
            this.ownerId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"requesterId")) {
            this.requesterId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"reservationId")) {
            this.reservationId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"amiLaunchIndex")) {
            this.builder.amiLaunchIndex(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"dnsName")) {
            this.builder.dnsName(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"imageId")) {
            this.builder.imageId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instanceId")) {
            this.builder.instanceId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"name")) {
            String rawState = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            this.builder.rawState(rawState);
            this.builder.instanceState(InstanceState.fromValue((String)rawState));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instanceType")) {
            this.builder.instanceType(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipAddress")) {
            this.builder.ipAddress(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"kernelId")) {
            this.builder.kernelId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"keyName")) {
            this.builder.keyName(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"launchTime")) {
            this.builder.launchTime(this.dateService.iso8601DateOrSecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"availabilityZone")) {
            this.builder.availabilityZone(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"virtualizationType")) {
            this.builder.virtualizationType(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"platform")) {
            this.builder.platform(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"privateDnsName")) {
            this.builder.privateDnsName(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"privateIpAddress")) {
            this.builder.privateIpAddress(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ramdiskId")) {
            this.builder.ramdiskId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"reason")) {
            this.builder.reason(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"rootDeviceType")) {
            this.builder.rootDeviceType(RootDeviceType.fromValue((String)SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"rootDeviceName")) {
            this.builder.rootDeviceName(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"deviceName")) {
            this.deviceName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"volumeId")) {
            this.volumeId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"status")) {
            this.attachmentStatus = Attachment.Status.fromValue((String)this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"attachTime")) {
            this.attachTime = this.dateService.iso8601DateOrSecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"deleteOnTermination")) {
            this.deleteOnTermination = Boolean.parseBoolean(this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ebs")) {
            this.builder.device(this.deviceName, new BlockDevice(this.volumeId, this.attachmentStatus, this.attachTime, this.deleteOnTermination));
            this.deviceName = null;
            this.volumeId = null;
            this.attachmentStatus = null;
            this.attachTime = null;
            this.deleteOnTermination = true;
        }
        this.currentText.setLength(0);
    }

    protected void inItem() {
        if (this.endOfInstanceItem()) {
            this.refineBuilderBeforeAddingInstance();
            this.instances.add(this.builder.build());
            this.builder = this.newBuilder();
        }
    }

    protected void refineBuilderBeforeAddingInstance() {
        String region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest()) : null;
        this.builder.region(region == null ? (String)this.defaultRegion.get() : region);
    }

    protected abstract boolean endOfInstanceItem();

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected Reservation<? extends RunningInstance> newReservation() {
        String region;
        String string = region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest()) : null;
        if (region == null) {
            region = (String)this.defaultRegion.get();
        }
        Reservation info = new Reservation(region, this.reservationGroupIdToNames.values(), this.instances, this.ownerId, this.requesterId, this.reservationId);
        this.reservationGroupIdToNames = Maps.newLinkedHashMap();
        this.instances = Sets.newLinkedHashSet();
        this.ownerId = null;
        this.requesterId = null;
        this.reservationId = null;
        return info;
    }
}

