/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.functions;

import com.google.common.base.Function;
import jakarta.inject.Singleton;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;

@Singleton
public class ParsePublicAccessHeader
implements Function<HttpResponse, PublicAccess> {
    public PublicAccess apply(HttpResponse from) {
        HttpUtils.releasePayload((HttpMessage)from);
        String access = from.getFirstHeaderOrNull("x-ms-blob-public-access");
        if (access == null) {
            return PublicAccess.PRIVATE;
        }
        return PublicAccess.valueOf(access.toUpperCase());
    }
}

