/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.config;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Map;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.GleSYSAsyncApi;
import org.jclouds.glesys.config.GleSYSParserModule;
import org.jclouds.glesys.features.ArchiveApi;
import org.jclouds.glesys.features.ArchiveAsyncApi;
import org.jclouds.glesys.features.DomainApi;
import org.jclouds.glesys.features.DomainAsyncApi;
import org.jclouds.glesys.features.EmailAccountApi;
import org.jclouds.glesys.features.EmailAccountAsyncApi;
import org.jclouds.glesys.features.IpApi;
import org.jclouds.glesys.features.IpAsyncApi;
import org.jclouds.glesys.features.ServerApi;
import org.jclouds.glesys.features.ServerAsyncApi;
import org.jclouds.glesys.handlers.GleSYSErrorHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.OnlyLocationOrFirstZone;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
public class GleSYSRestClientModule
extends RestClientModule<GleSYSApi, GleSYSAsyncApi> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(ServerApi.class, ServerAsyncApi.class).put(IpApi.class, IpAsyncApi.class).put(ArchiveApi.class, ArchiveAsyncApi.class).put(DomainApi.class, DomainAsyncApi.class).put(EmailAccountApi.class, EmailAccountAsyncApi.class).build();

    public GleSYSRestClientModule() {
        super(DELEGATE_MAP);
    }

    protected void configure() {
        this.install((Module)new GleSYSParserModule());
        super.configure();
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(GleSYSErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(GleSYSErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(GleSYSErrorHandler.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(BackoffLimitedRetryHandler.class);
    }

    protected void installLocations() {
        super.installLocations();
        this.bind(ImplicitLocationSupplier.class).to(OnlyLocationOrFirstZone.class).in(Scopes.SINGLETON);
    }
}

