/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.compute.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.glesys.compute.functions.ServerDetailsToNodeMetadata;
import org.jclouds.glesys.compute.internal.BaseGleSYSComputeServiceExpectTest;
import org.jclouds.glesys.features.ServerApiExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ServerDetailsToNodeMetadataTest")
public class ServerDetailsToNodeMetadataTest
extends BaseGleSYSComputeServiceExpectTest {
    @Test
    public void testServerDetailsRequest() {
        ServerDetailsToNodeMetadata toTest = (ServerDetailsToNodeMetadata)this.injectorForKnownArgumentsAndConstantPassword((Map<HttpRequest, HttpResponse>)ImmutableMap.builder().put((Object)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/server/details/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).payload((Payload)Payloads.newUrlEncodedFormPayload((Multimap)ImmutableMultimap.builder().put((Object)"serverid", (Object)"xm3276891").build()))).build(), (Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/server_details.json"))).build()).build()).getInstance(ServerDetailsToNodeMetadata.class);
        NodeMetadata actual = toTest.apply(ServerApiExpectTest.expectedServerDetails());
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((String)actual.toString(), (String)new NodeMetadataBuilder().ids("vz1840356").name("glesys-s").hostname("glesys-s").group("glesys").imageId("Ubuntu 10.04 LTS 32-bit").operatingSystem(OperatingSystem.builder().name("Ubuntu 10.04 LTS 32-bit").family(OsFamily.UBUNTU).version("10.04").is64Bit(false).description("Ubuntu 10.04 LTS 32-bit").build()).publicAddresses((Iterable)ImmutableSet.of((Object)"31.192.231.254")).hardware(new HardwareBuilder().ids("vz1840356").ram(512).processors((Iterable)ImmutableList.of((Object)new Processor(1.0, 1.0))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(5.0f), true, true))).hypervisor("OpenVZ").build()).status(NodeMetadata.Status.RUNNING).build().toString());
    }
}

