/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.handlers;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.IOException;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;

@Singleton
public class GleSYSErrorHandler
implements HttpErrorHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        void var4_10;
        String message = this.parseMessage(response);
        HttpResponseException httpResponseException = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        try {
            message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
            switch (response.getStatusCode()) {
                case 401: 
                case 403: {
                    AuthorizationException authorizationException = new AuthorizationException(message, (Throwable)httpResponseException);
                    break;
                }
                case 400: {
                    if (message.indexOf("not find") == -1) break;
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)httpResponseException);
                    break;
                }
                case 404: {
                    if (message.indexOf("Not supported") != -1) {
                        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(message, (Throwable)httpResponseException);
                        break;
                    }
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)httpResponseException);
                    break;
                }
                case 500: {
                    if (message.indexOf("Locked") == -1) break;
                    IllegalStateException illegalStateException = new IllegalStateException(message, (Throwable)httpResponseException);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly((Closeable)response.getPayload());
            command.setException((Exception)httpResponseException);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)response.getPayload());
        command.setException((Exception)var4_10);
    }

    public String parseMessage(HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        try {
            String string = Strings2.toString((InputSupplier)response.getPayload());
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                response.getPayload().getInput().close();
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }
}

