/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.glesys.domain.OSTemplate;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

@Singleton
public class ParseTemplatesFromHttpResponse
implements Function<HttpResponse, FluentIterable<OSTemplate>> {
    private final ParseFirstJsonValueNamed<Map<String, Set<OSTemplate>>> parser;

    @Inject
    public ParseTemplatesFromHttpResponse(GsonWrapper gsonView) {
        this.parser = new ParseFirstJsonValueNamed((GsonWrapper)Preconditions.checkNotNull((Object)gsonView, (Object)"gsonView"), (TypeLiteral)new TypeLiteral<Map<String, Set<OSTemplate>>>(){}, new String[]{"templates"});
    }

    public FluentIterable<OSTemplate> apply(HttpResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        Map toParse = (Map)this.parser.apply(response);
        Preconditions.checkNotNull((Object)toParse, (String)"parsed result from %s", (Object[])new Object[]{response});
        return FluentIterable.from((Iterable)Iterables.concat(toParse.values()));
    }
}

