/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.glesys.domain.OSTemplate;

@Singleton
public class OSTemplateToImage
implements Function<OSTemplate, Image> {
    private final Function<String, OsFamilyVersion64Bit> osParser;

    @Inject
    public OSTemplateToImage(Function<String, OsFamilyVersion64Bit> osParser) {
        this.osParser = osParser;
    }

    public Image apply(OSTemplate template) {
        Preconditions.checkNotNull((Object)template, (Object)"template");
        OsFamilyVersion64Bit parsed = (OsFamilyVersion64Bit)this.osParser.apply((Object)template.getName());
        OperatingSystem.Builder builder = OperatingSystem.builder();
        builder.name(template.getName()).description(template.getName()).is64Bit(parsed.is64Bit).version(parsed.version).family(parsed.family);
        return new ImageBuilder().ids(template.getName()).name(template.getName()).description(template.getName()).operatingSystem(builder.build()).status(Image.Status.AVAILABLE).build();
    }
}

