/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.glesys.domain.GleSYSBoolean;

public class Archive {
    private final String username;
    private final String totalSize;
    private final String freeSize;
    private final boolean locked;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromArchive(this);
    }

    @ConstructorProperties(value={"username", "sizetotal", "sizefree", "locked"})
    protected Archive(String username, String totalSize, String freeSize, GleSYSBoolean locked) {
        this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
        this.totalSize = (String)Preconditions.checkNotNull((Object)totalSize, (Object)"totalSize");
        this.freeSize = (String)Preconditions.checkNotNull((Object)freeSize, (Object)"freeSize");
        this.locked = ((GleSYSBoolean)Preconditions.checkNotNull((Object)locked, (Object)"locked")).getValue();
    }

    public String getUsername() {
        return this.username;
    }

    public String getTotalSize() {
        return this.totalSize;
    }

    public String getFreeSize() {
        return this.freeSize;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.username, this.totalSize, this.freeSize, this.locked});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Archive that = (Archive)Archive.class.cast(obj);
        return Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.totalSize, (Object)that.totalSize) && Objects.equal((Object)this.freeSize, (Object)that.freeSize) && Objects.equal((Object)this.locked, (Object)that.locked);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("username", (Object)this.username).add("totalSize", (Object)this.totalSize).add("freeSize", (Object)this.freeSize).add("locked", this.locked);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String username;
        protected String totalSize;
        protected String freeSize;
        protected boolean locked;

        protected abstract T self();

        public T username(String username) {
            this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
            return this.self();
        }

        public T totalSize(String totalSize) {
            this.totalSize = (String)Preconditions.checkNotNull((Object)totalSize, (Object)"totalSize");
            return this.self();
        }

        public T freeSize(String freeSize) {
            this.freeSize = (String)Preconditions.checkNotNull((Object)freeSize, (Object)"freeSize");
            return this.self();
        }

        public T locked(boolean locked) {
            this.locked = locked;
            return this.self();
        }

        public Archive build() {
            return new Archive(this.username, this.totalSize, this.freeSize, new GleSYSBoolean(this.locked));
        }

        public T fromArchive(Archive in) {
            return ((Builder)((Builder)((Builder)this.username(in.getUsername())).totalSize(in.getTotalSize())).freeSize(in.getFreeSize())).locked(in.isLocked());
        }
    }
}

