/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.all.JustProvider;

public class DatacenterToLocation
implements Function<String, Location> {
    private final JustProvider provider;

    @Inject
    public DatacenterToLocation(JustProvider provider) {
        this.provider = (JustProvider)Preconditions.checkNotNull((Object)provider, (Object)"provider");
    }

    public Location apply(String datacenter) {
        return new LocationBuilder().scope(LocationScope.ZONE).description(datacenter).id(datacenter).parent((Location)Iterables.getOnlyElement((Iterable)this.provider.get())).build();
    }
}

