/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Set;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.domain.Archive;
import org.jclouds.glesys.domain.ArchiveAllowedArguments;
import org.jclouds.glesys.features.ArchiveApi;
import org.jclouds.glesys.internal.BaseGleSYSApiExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ArchiveApiExpectTest")
public class ArchiveApiExpectTest
extends BaseGleSYSApiExpectTest {
    public void testListArchivesWhenReponseIs2xx() throws Exception {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/archive/list/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/archive_list.json"))).build())).getArchiveApi();
        ImmutableSet expected = ImmutableSet.of((Object)Archive.builder().username("xxxxx_test1").freeSize("20 GB").totalSize("30 GB").locked(false).build());
        Assert.assertEquals((Set)api.list().toSet(), (Set)expected);
    }

    public void testListArchivesWhenResponseIs4xxReturnsEmpty() {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/archive/list/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), HttpResponse.builder().statusCode(404).build())).getArchiveApi();
        Assert.assertTrue((boolean)api.list().isEmpty());
    }

    public void testArchiveDetailsWhenResponseIs2xx() throws Exception {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/archive/details/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("username", new String[]{"xxxxxx_test1"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/archive_details.json"))).build())).getArchiveApi();
        Assert.assertEquals((Object)api.get("xxxxxx_test1"), (Object)this.detailsInArchiveDetails());
    }

    private Archive detailsInArchiveDetails() {
        return Archive.builder().username("xxxxxx_test1").freeSize("30 GB").totalSize("30 GB").locked(false).build();
    }

    public void testArchiveDetailsWhenResponseIs4xxReturnsNull() {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/archive/details/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("username", new String[]{"xxxxxx_test1"}).build(), HttpResponse.builder().statusCode(404).build())).getArchiveApi();
        Assert.assertNull((Object)api.get("xxxxxx_test1"));
    }

    public void testCreateArchiveWhenResponseIs2xx() throws Exception {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/archive/create/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParams((Multimap)ImmutableMultimap.builder().put((Object)"username", (Object)"xxxxxx_test1").put((Object)"password", (Object)"somepass").put((Object)"size", (Object)"5").build()).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/archive_details.json"))).build())).getArchiveApi();
        Assert.assertEquals((Object)api.createWithCredentialsAndSize("xxxxxx_test1", "somepass", 5), (Object)this.detailsInArchiveDetails());
    }

    public void testDeleteArchiveWhenResponseIs2xx() throws Exception {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/archive/delete/format/json").addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("username", new String[]{"xxxxxx_test1"}).build(), HttpResponse.builder().statusCode(200).build())).getArchiveApi();
        api.delete("xxxxxx_test1");
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testDeleteArchiveWhenResponseIs4xxThrows() throws Exception {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/archive/delete/format/json").addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("username", new String[]{"xxxxxx_test1"}).build(), HttpResponse.builder().statusCode(402).build())).getArchiveApi();
        api.delete("xxxxxx_test1");
    }

    public void testResizeArchiveWhenResponseIs2xx() throws Exception {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/archive/resize/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("username", new String[]{"username1"}).addFormParam("size", new String[]{"5"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/archive_details.json"))).build())).getArchiveApi();
        Assert.assertEquals((Object)api.resize("username1", 5), (Object)this.detailsInArchiveDetails());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testResizeArchiveWhenResponseIs4xxThrows() throws Exception {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/archive/resize/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("username", new String[]{"username1"}).addFormParam("size", new String[]{"5"}).build(), HttpResponse.builder().statusCode(404).build())).getArchiveApi();
        api.resize("username1", 5);
    }

    public void testChangeArchivePasswordWhenResponseIs2xx() throws Exception {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/archive/changepassword/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("username", new String[]{"username"}).addFormParam("password", new String[]{"newpass"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/archive_details.json"))).build())).getArchiveApi();
        Assert.assertEquals((Object)api.changePassword("username", "newpass"), (Object)this.detailsInArchiveDetails());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testChangeArchivePasswordWhenResponseIs4xxThrows() throws Exception {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/archive/changepassword/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("username", new String[]{"username"}).addFormParam("password", new String[]{"newpass"}).build(), HttpResponse.builder().statusCode(404).build())).getArchiveApi();
        api.changePassword("username", "newpass");
    }

    public void testGetArchiveAllowedArgumentsWhenResponseIs2xx() throws Exception {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.glesys.com/archive/allowedarguments/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/archive_allowed_arguments.json"))).build())).getArchiveApi();
        ArchiveAllowedArguments expected = ArchiveAllowedArguments.builder().archiveSizes(new Integer[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 125, 150, 175, 200, 225, 250, 275, 300, 325, 350, 375, 400, 425, 450, 475, 500, 550, 600, 650, 700, 750, 800, 850, 900, 950, 1000}).build();
        Assert.assertEquals((Object)api.getAllowedArguments(), (Object)expected);
    }

    public void testGetArchiveAllowedArguments4xxWhenResponseIs2xx() throws Exception {
        ArchiveApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.glesys.com/archive/allowedarguments/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), HttpResponse.builder().statusCode(404).build())).getArchiveApi();
        Assert.assertNull((Object)api.getAllowedArguments());
    }
}

