/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.glesys.domain.Archive;
import org.jclouds.glesys.domain.ArchiveAllowedArguments;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={BasicAuthentication.class})
public interface ArchiveApi {
    @Named(value="archive:list")
    @POST
    @Path(value="/archive/list/format/json")
    @SelectJson(value={"archives"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<Archive> list();

    @Named(value="archive:details")
    @POST
    @Path(value="/archive/details/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Archive get(@FormParam(value="username") String var1);

    @Named(value="archive:create")
    @POST
    @Path(value="/archive/create/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    public Archive createWithCredentialsAndSize(@FormParam(value="username") String var1, @FormParam(value="password") String var2, @FormParam(value="size") int var3);

    @Named(value="archive:delete")
    @POST
    @Path(value="/archive/delete/format/json")
    public void delete(@FormParam(value="username") String var1);

    @Named(value="archive:resize")
    @POST
    @Path(value="/archive/resize/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    public Archive resize(@FormParam(value="username") String var1, @FormParam(value="size") int var2);

    @Named(value="archive:changepassword")
    @POST
    @Path(value="/archive/changepassword/format/json")
    @SelectJson(value={"details"})
    @Consumes(value={"application/json"})
    public Archive changePassword(@FormParam(value="username") String var1, @FormParam(value="password") String var2);

    @Named(value="archive:allowedarguments")
    @GET
    @Path(value="/archive/allowedarguments/format/json")
    @SelectJson(value={"argumentslist"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ArchiveAllowedArguments getAllowedArguments();
}

