/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.domain.Archive;
import org.jclouds.glesys.domain.ArchiveAllowedArguments;
import org.jclouds.glesys.features.ArchiveApi;
import org.jclouds.glesys.internal.BaseGleSYSApiLiveTest;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ArchiveApiLiveTest", singleThreaded=true)
public class ArchiveApiLiveTest
extends BaseGleSYSApiLiveTest {
    private ArchiveApi archiveApi;
    private String archiveUser;
    private Predicate<Integer> archiveCounter;

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.archiveApi = ((GleSYSApi)this.api).getArchiveApi();
        this.archiveUser = this.identity.toLowerCase() + "_test9";
        this.archiveCounter = Predicates2.retry((Predicate)new Predicate<Integer>(){

            public boolean apply(Integer value) {
                return ArchiveApiLiveTest.this.archiveApi.list().size() == value.intValue();
            }
        }, (long)30L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        int before = this.archiveApi.list().size();
        this.archiveApi.delete(this.archiveUser);
        Assert.assertTrue((boolean)this.archiveCounter.apply((Object)(before - 1)));
        super.tearDown();
    }

    @Test
    public void testAllowedArguments() throws Exception {
        ArchiveAllowedArguments args = this.archiveApi.getAllowedArguments();
        Assert.assertNotNull((Object)args);
        Assert.assertNotNull((Object)args.getSizes());
        Assert.assertTrue((args.getSizes().size() > 0 ? 1 : 0) != 0);
        Iterator i$ = args.getSizes().iterator();
        while (i$.hasNext()) {
            int size = (Integer)i$.next();
            Assert.assertTrue((size > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCreateArchive() throws Exception {
        try {
            this.archiveApi.delete(this.archiveUser);
        }
        catch (Exception ex) {
            // empty catch block
        }
        int before = this.archiveApi.list().size();
        this.archiveApi.createWithCredentialsAndSize(this.archiveUser, "password", 10);
        Assert.assertTrue((boolean)this.archiveCounter.apply((Object)(before + 1)));
    }

    @Test(dependsOnMethods={"testCreateArchive"})
    public void testArchiveDetails() throws Exception {
        Archive details = this.archiveApi.get(this.archiveUser);
        Assert.assertEquals((String)details.getUsername(), (String)this.archiveUser);
    }

    @Test(dependsOnMethods={"testCreateArchive"})
    public void testChangePassword() throws Exception {
        this.archiveApi.changePassword(this.archiveUser, "newpassword");
    }

    @Test(dependsOnMethods={"testCreateArchive"})
    public void testResizeArchive() throws Exception {
        this.archiveApi.resize(this.archiveUser, 20);
        Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<String>(){

            public boolean apply(String value) {
                return ArchiveApiLiveTest.this.archiveApi.get(ArchiveApiLiveTest.this.archiveUser) != null && value.equals(ArchiveApiLiveTest.this.archiveApi.get(ArchiveApiLiveTest.this.archiveUser).getTotalSize());
            }
        }, (long)30L, (long)1L, (TimeUnit)TimeUnit.SECONDS).apply((Object)"20 GB"));
    }
}

