/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.domain.AllowedArgumentsForCreateServer;
import org.jclouds.glesys.domain.Console;
import org.jclouds.glesys.domain.OSTemplate;
import org.jclouds.glesys.domain.ResourceStatus;
import org.jclouds.glesys.domain.ResourceUsage;
import org.jclouds.glesys.domain.Server;
import org.jclouds.glesys.domain.ServerDetails;
import org.jclouds.glesys.domain.ServerLimit;
import org.jclouds.glesys.domain.ServerStatus;
import org.jclouds.glesys.features.ServerApi;
import org.jclouds.glesys.internal.BaseGleSYSApiWithAServerLiveTest;
import org.jclouds.glesys.options.CloneServerOptions;
import org.jclouds.glesys.options.DestroyServerOptions;
import org.jclouds.glesys.options.ServerStatusOptions;
import org.jclouds.glesys.options.UpdateServerOptions;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ServerApiLiveTest", singleThreaded=true)
public class ServerApiLiveTest
extends BaseGleSYSApiWithAServerLiveTest {
    public static final String testHostName2 = "jclouds-test2";
    private ServerApi serverApi;
    private String testServerId2;

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        this.hostName = this.hostName + "-server";
        super.setup();
        this.serverApi = ((GleSYSApi)this.api).getServerApi();
    }

    @Override
    @AfterClass(groups={"integration", "live"})
    public void tearDown() {
        if (this.testServerId2 != null) {
            this.serverApi.destroy(this.testServerId2, DestroyServerOptions.Builder.discardIp());
        }
        super.tearDown();
    }

    @BeforeMethod
    public void makeSureServerIsRunning() throws Exception {
        this.serverStatusChecker.apply((Object)Server.State.RUNNING);
    }

    @Test
    public void testAllowedArguments() throws Exception {
        Map templates = this.serverApi.getAllowedArgumentsForCreateByPlatform();
        Assert.assertTrue((boolean)templates.containsKey("OpenVZ"));
        Assert.assertTrue((boolean)templates.containsKey("Xen"));
        this.checkAllowedArguments((AllowedArgumentsForCreateServer)templates.get("OpenVZ"));
        this.checkAllowedArguments((AllowedArgumentsForCreateServer)templates.get("Xen"));
    }

    private void checkAllowedArguments(AllowedArgumentsForCreateServer t) {
        Assert.assertNotNull((Object)t);
        assert (t.getDataCenters().size() > 0) : t;
        assert (t.getCpuCoreOptions().getAllowedUnits().size() > 0) : t;
        assert (t.getDiskSizesInGB().getAllowedUnits().size() > 0) : t;
        assert (t.getMemorySizesInMB().getAllowedUnits().size() > 0) : t;
        assert (t.getTemplateNames().size() > 0) : t;
        assert (t.getTransfersInGB().getAllowedUnits().size() > 0) : t;
        assert (t.getTransfersInGB().getAllowedUnits().size() > 0) : t;
    }

    public void testListTemplates() throws Exception {
        FluentIterable oSTemplates = this.serverApi.listTemplates();
        for (OSTemplate oSTemplate : oSTemplates) {
            this.checkTemplate(oSTemplate);
        }
    }

    private void checkTemplate(OSTemplate t) {
        Assert.assertNotNull((Object)t);
        Assert.assertNotNull((Object)t.getName());
        Assert.assertNotNull((Object)t.getOs());
        Assert.assertNotNull((Object)t.getPlatform());
        assert (t.getMinDiskSize() > 0) : t;
        assert (t.getMinMemSize() > 0) : t;
    }

    public void testListServers() throws Exception {
        FluentIterable response = this.serverApi.list();
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((response.size() > 0 ? 1 : 0) != 0);
        for (Server server : response) {
            ServerDetails newDetails = this.serverApi.get(server.getId());
            Assert.assertEquals((String)newDetails.getId(), (String)server.getId());
            Assert.assertEquals((String)newDetails.getHostname(), (String)server.getHostname());
            Assert.assertEquals((String)newDetails.getPlatform(), (String)server.getPlatform());
            Assert.assertEquals((String)newDetails.getDatacenter(), (String)server.getDatacenter());
            this.checkServer(newDetails);
        }
    }

    public void testServerDetails() throws Exception {
        ServerDetails details = this.serverApi.get(this.serverId);
        this.checkServer(details);
        Assert.assertEquals((String)"Ubuntu 10.04 LTS 32-bit", (String)details.getTemplateName());
        Assert.assertEquals((String)"Falkenberg", (String)details.getDatacenter());
        Assert.assertEquals((String)"OpenVZ", (String)details.getPlatform());
        Assert.assertEquals((int)5, (int)details.getDiskSizeGB());
        Assert.assertEquals((int)512, (int)details.getMemorySizeMB());
        Assert.assertEquals((int)1, (int)details.getCpuCores());
        Assert.assertEquals((int)50, (int)details.getTransferGB());
    }

    public void testServerStatus() throws Exception {
        ServerStatus newStatus = this.serverApi.getStatus(this.serverId, new ServerStatusOptions[0]);
        this.checkStatus(newStatus);
    }

    public void testUpdateServer() throws Exception {
        ServerDetails edited = this.serverApi.update(this.serverId, UpdateServerOptions.Builder.description((String)"this is a different description!"));
        Assert.assertEquals((String)edited.getDescription(), (String)"this is a different description!");
        edited = this.serverApi.update(this.serverId, UpdateServerOptions.Builder.description((String)"another description!").hostname("host-name1"));
        Assert.assertEquals((String)edited.getDescription(), (String)"another description!");
        Assert.assertEquals((String)edited.getHostname(), (String)"host-name1");
        edited = this.serverApi.resetPassword(this.serverId, "anotherpass");
        Assert.assertEquals((String)edited.getHostname(), (String)"host-name1");
        edited = this.serverApi.update(this.serverId, UpdateServerOptions.Builder.hostname((String)this.hostName));
        Assert.assertEquals((String)edited.getHostname(), (String)this.hostName);
    }

    @Test
    public void testRebootServer() throws Exception {
        Assert.assertTrue((boolean)this.serverStatusChecker.apply((Object)Server.State.RUNNING));
        this.serverApi.reboot(this.serverId);
        Assert.assertTrue((boolean)this.serverStatusChecker.apply((Object)Server.State.RUNNING));
    }

    @Test
    public void testStopAndStartServer() throws Exception {
        Assert.assertTrue((boolean)this.serverStatusChecker.apply((Object)Server.State.RUNNING));
        this.serverApi.stop(this.serverId);
        Assert.assertTrue((boolean)this.serverStatusChecker.apply((Object)Server.State.STOPPED));
        this.serverApi.start(this.serverId);
        Assert.assertTrue((boolean)this.serverStatusChecker.apply((Object)Server.State.RUNNING));
    }

    public void testServerLimits() throws Exception {
        SortedMap limits = this.serverApi.getLimits(this.serverId);
        Assert.assertNotNull((Object)limits);
        for (Map.Entry entry : limits.entrySet()) {
            Assert.assertNotNull(entry.getKey());
            Assert.assertNotNull(entry.getValue());
            ServerLimit limit = (ServerLimit)entry.getValue();
            Assert.assertTrue((limit.getBarrier() >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)limit.getFailCount());
            Assert.assertTrue((limit.getHeld() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((limit.getLimit() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((limit.getMaxHeld() >= 0L ? 1 : 0) != 0);
        }
    }

    public void testResourceUsage() throws Exception {
        for (Server server : this.serverApi.list()) {
            ResourceUsage usage;
            try {
                usage = this.serverApi.getResourceUsage(server.getId(), "diskioread", "minute");
                Assert.assertEquals((String)usage.getInfo().getResource(), (String)"diskioread");
                Assert.assertEquals((String)usage.getInfo().getResolution(), (String)"minute");
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            try {
                usage = this.serverApi.getResourceUsage(server.getId(), "cpuusage", "minute");
                Assert.assertEquals((String)usage.getInfo().getResource(), (String)"cpuusage");
                Assert.assertEquals((String)usage.getInfo().getResolution(), (String)"minute");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public void testConsole() throws Exception {
        Console console = this.serverApi.getConsole(this.serverId);
        Assert.assertNotNull((Object)console);
        Assert.assertNotNull((Object)console.getHost());
        Assert.assertTrue((console.getPort() > 0 && console.getPort() < 65537 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)console.getPassword());
    }

    @Test(enabled=false)
    public void testCloneServer() throws Exception {
        ServerDetails testServer2 = this.serverApi.clone(this.serverId, testHostName2, new CloneServerOptions[]{CloneServerOptions.Builder.cpucores((int)1)});
        Assert.assertNotNull((Object)testServer2.getId());
        Assert.assertEquals((String)testServer2.getHostname(), (String)testHostName2);
        Assert.assertTrue((boolean)testServer2.getIps().isEmpty());
        this.testServerId2 = testServer2.getId();
        Predicate cloneChecker = this.statusChecker(this.serverApi, this.testServerId2);
        Assert.assertTrue((boolean)cloneChecker.apply((Object)Server.State.STOPPED));
        this.serverApi.start(testServer2.getId());
        cloneChecker = Predicates2.retry((Predicate)new Predicate<Server.State>(){

            public boolean apply(Server.State value) {
                ServerStatus status = ServerApiLiveTest.this.serverApi.getStatus(ServerApiLiveTest.this.testServerId2, new ServerStatusOptions[]{ServerStatusOptions.Builder.state()});
                if (status.getState() == value) {
                    return true;
                }
                ServerApiLiveTest.this.serverApi.start(ServerApiLiveTest.this.testServerId2);
                return false;
            }
        }, (long)600L, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertTrue((boolean)cloneChecker.apply((Object)Server.State.RUNNING));
    }

    private void checkServer(ServerDetails server) {
        assert (server.getCpuCores() > 0) : server;
        assert (server.getDiskSizeGB() > 0) : server;
        assert (server.getMemorySizeMB() > 0) : server;
        assert (server.getCost() != null);
        assert (server.getTransferGB() > 0) : server;
        Assert.assertNotNull((Object)server.getTemplateName());
        Assert.assertNotNull((Object)server.getIps());
    }

    private void checkStatus(ServerStatus status) {
        Assert.assertNotNull((Object)status.getState());
        Assert.assertNotNull((Object)status.getUptime());
        for (ResourceStatus usage : new ResourceStatus[]{status.getCpu(), status.getDisk(), status.getMemory()}) {
            Assert.assertNotNull((Object)usage);
            assert (usage.getMax() >= 0.0) : status;
            assert (usage.getUsage() >= 0.0) : status;
            Assert.assertNotNull((Object)usage.getUnit());
        }
        Assert.assertNotNull((Object)status.getUptime());
        assert (status.getUptime().getCurrent() > 0L) : status;
        Assert.assertNotNull((Object)status.getUptime().getUnit());
    }
}

